/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.config;

import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class TaskExecutorConfig {
    private final EntityManagementConfiguration emConfig;

    public TaskExecutorConfig(EntityManagementConfiguration emConfig) {
        this.emConfig = emConfig;
    }

    @Bean(value={"scheduledUpdateTaskExecutor"})
    public TaskExecutor scheduledUpdateExecutor() {
        return new SyncTaskExecutor();
    }

    @Bean(value={"scheduledRemovalTaskExecutor"})
    public TaskExecutor scheduledDeletionsExecutor() {
        return new SyncTaskExecutor();
    }

    @Bean(value={"updatesStepExecutor"})
    public TaskExecutor updatesStepExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.emConfig.getBatchUpdatesCorePoolSize());
        taskExecutor.setMaxPoolSize(this.emConfig.getBatchUpdatesMaxPoolSize());
        taskExecutor.setQueueCapacity(this.emConfig.getBatchUpdatesQueueSize());
        return taskExecutor;
    }

    @Bean(value={"removalsStepExecutor"})
    public TaskExecutor removalsStepExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.emConfig.getBatchRemovalsCorePoolSize());
        taskExecutor.setMaxPoolSize(this.emConfig.getBatchRemovalsMaxPoolSize());
        taskExecutor.setQueueCapacity(this.emConfig.getBatchRemovalsQueueSize());
        return taskExecutor;
    }

    @Bean(value={"webRequestTaskExecutor"})
    public TaskExecutor synchronousExecutor() {
        return new SyncTaskExecutor();
    }
}

