/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement;

import eu.europeana.entitymanagement.batch.model.JobType;
import eu.europeana.entitymanagement.batch.service.BatchEntityUpdateExecutor;
import eu.europeana.entitymanagement.web.service.ZohoSyncService;
import java.util.Arrays;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(scanBasePackages={"eu.europeana.entitymanagement"}, exclude={SecurityAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class, DataSourceAutoConfiguration.class})
public class EntityManagementApp
implements CommandLineRunner {
    private static final Logger LOG = LogManager.getLogger(EntityManagementApp.class);
    @Autowired
    private BatchEntityUpdateExecutor batchUpdateExecutor;
    @Autowired
    private ZohoSyncService zohoSyncService;

    public static void main(String[] args) {
        if (!EntityManagementApp.hasCmdLineParams((String[])args)) {
            LOG.info("No args provided to application. Starting web server");
            SpringApplication.run(EntityManagementApp.class, (String[])args);
            return;
        }
        LOG.info("Starting batch updates execution with args: {}", (Object)Arrays.toString(args));
        EntityManagementApp.validateArguments((String[])args);
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{EntityManagementApp.class}).web(WebApplicationType.NONE).run(args);
        LOG.info("Batch update execution complete for {}. Stopping application. ", (Object)Arrays.toString(args));
        System.exit(SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]));
    }

    static boolean hasCmdLineParams(String[] args) {
        return args != null && args.length > 0;
    }

    public void run(String ... args) throws Exception {
        if (EntityManagementApp.hasCmdLineParams((String[])args)) {
            Set<String> tasks = Set.of(args);
            if (tasks.contains(JobType.SCHEDULE_DELETION.value())) {
                LOG.info("Executing scheduled deletions");
                this.batchUpdateExecutor.runScheduledDeprecationsAndDeletions();
            }
            if (tasks.contains(JobType.ZOHO_SYNC.value())) {
                LOG.info("Executing zoho sync");
                this.zohoSyncService.synchronizeModifiedZohoOrganizations();
            }
            if (tasks.contains(JobType.SCHEDULE_UPDATE.value())) {
                LOG.info("Executing scheduled updates");
                this.batchUpdateExecutor.runScheduledUpdate();
            }
        }
    }

    private static void validateArguments(String[] args) {
        for (String arg : args) {
            if (JobType.isValidJobType((String)arg)) continue;
            String allowdJobTypes = JobType.values().toString();
            LOG.error("Unsupported argument '{}'. Supported arguments are '{}'", (Object)arg, (Object)allowdJobTypes);
            System.exit(1);
        }
    }
}

