/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import eu.europeana.entitymanagement.common.config.SocksProxyConfig;
import io.micrometer.core.instrument.util.StringUtils;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SocksProxyActivator {
    private static final Logger LOG = LogManager.getLogger(SocksProxyActivator.class);

    private SocksProxyActivator() {
    }

    public static boolean activate(SocksProxyConfig config) {
        if (!SocksProxyActivator.isValidConfiguration(config)) {
            return false;
        }
        System.setProperty("socksProxyHost", config.getHost());
        System.setProperty("socksProxyPort", config.getPort());
        String user = config.getUser();
        if (StringUtils.isNotBlank((String)user)) {
            String pass = config.getPassword();
            System.setProperty("java.net.socks.username", user);
            System.setProperty("java.net.socks.password", pass);
            Authenticator.setDefault(new SockProxyAuthenticator(user, pass));
        }
        return true;
    }

    private static boolean isValidConfiguration(SocksProxyConfig config) {
        boolean result = false;
        if (StringUtils.isEmpty((String)config.getHost())) {
            LOG.info("No socks proxy configured");
        } else if (!config.isSocksEnabled()) {
            LOG.info("Socks proxy disabled");
        } else {
            LOG.info("Setting up socks proxy at {}", (Object)config.getHost());
            result = true;
        }
        return result;
    }

    private static class SockProxyAuthenticator
    extends Authenticator {
        private final String user;
        private final char[] password;

        SockProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password.toCharArray();
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

