/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.repository;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import dev.morphia.Datastore;
import dev.morphia.aggregation.experimental.stages.Lookup;
import dev.morphia.aggregation.experimental.stages.Projection;
import dev.morphia.aggregation.experimental.stages.Unwind;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.internal.MorphiaCursor;
import eu.europeana.entitymanagement.definitions.batch.EMBatchConstants;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.FailedTask;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTask;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.mongo.utils.MorphiaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class ScheduledTaskRepository
implements InitializingBean {
    private final Datastore datastore;

    @Autowired
    public ScheduledTaskRepository(@Qualifier(value="emDataStore") Datastore datastore) {
        this.datastore = datastore;
    }

    public void afterPropertiesSet() {
        this.datastore.ensureIndexes(ScheduledTask.class);
    }

    public BulkWriteResult markAsProcessed(List<ScheduledTask> tasks) {
        ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>();
        for (ScheduledTask task : tasks) {
            updates.add(new UpdateOneModel((Bson)new Document("entityId", (Object)task.getEntityId()).append("updateType", (Object)task.getUpdateType().getValue()), (Bson)new Document("$set", (Object)new Document("hasBeenProcessed", (Object)task.hasBeenProcessed()).append("modified", (Object)task.getModified()))));
        }
        return this.datastore.getMapper().getCollection(ScheduledTask.class).bulkWrite(updates);
    }

    public BulkWriteResult upsertBulk(List<ScheduledTask> tasks) {
        MongoCollection collection = this.datastore.getMapper().getCollection(ScheduledTask.class);
        ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>();
        for (ScheduledTask task : tasks) {
            boolean shouldChangeUpdateType;
            Document updateDoc = new Document("entityId", (Object)task.getEntityId()).append("hasBeenProcessed", (Object)task.hasBeenProcessed()).append("modified", (Object)task.getModified());
            Document setOnInsertDoc = new Document("created", (Object)task.getModified()).append("_t", (Object)EMBatchConstants.SCHEDULED_TASK_CLASSNAME);
            boolean bl = shouldChangeUpdateType = task.getUpdateType() == ScheduledUpdateType.FULL_UPDATE;
            if (shouldChangeUpdateType) {
                updateDoc.append("updateType", (Object)task.getUpdateType().getValue());
            } else {
                setOnInsertDoc.append("updateType", (Object)task.getUpdateType().getValue());
            }
            updates.add(new UpdateOneModel((Bson)new Document("entityId", (Object)task.getEntityId()), (Bson)new Document("$set", (Object)updateDoc).append("$setOnInsert", (Object)setOnInsertDoc), (UpdateOptions)MorphiaUtils.UPSERT_OPTS));
        }
        return collection.bulkWrite(updates);
    }

    public long removeProcessedTasks(List<? extends ScheduledTaskType> updateType) {
        return this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.eq((String)"hasBeenProcessed", (Object)true), Filters.or((Filter[])((Filter[])updateType.stream().map(u -> Filters.eq((String)"updateType", (Object)u.getValue())).toArray(Filter[]::new)))}).delete(MorphiaUtils.MULTI_DELETE_OPTS).getDeletedCount();
    }

    public void deleteScheduledTask(String entityId) {
        this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).delete();
    }

    public List<BatchEntityRecord> getEntityRecordsForTasks(int start, int count, Filter[] filters) {
        List scheduledTasks = this.datastore.find(ScheduledTask.class).filter(filters).iterator(new FindOptions().projection().include(new String[]{"entityId", "updateType"}).skip(start).sort(new Sort[]{Sort.ascending((String)"created"), Sort.ascending((String)"entityId")}).limit(count)).toList();
        Map<String, ScheduledTaskType> taskTypeMap = scheduledTasks.stream().collect(Collectors.toMap(ScheduledTask::getEntityId, ScheduledTask::getUpdateType));
        List entityRecords = this.datastore.find(EntityRecord.class).filter(new Filter[]{Filters.in((String)"entityId", taskTypeMap.keySet())}).iterator().toList();
        return entityRecords.stream().map(r -> new BatchEntityRecord(r, (ScheduledTaskType)taskTypeMap.get(r.getEntityId()))).collect(Collectors.toList());
    }

    public ScheduledTask getTask(String entityId) {
        return (ScheduledTask)this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).first();
    }

    public List<ScheduledTask> getTasks(List<String> entityIds) {
        return this.datastore.find(ScheduledTask.class).filter(new Filter[]{Filters.in((String)"entityId", entityIds)}).iterator().toList();
    }

    public void dropCollection() {
        this.datastore.getMapper().getCollection(ScheduledTask.class).drop();
    }

    public MorphiaCursor<ScheduledTask> getTasksWithFailures(int maxFailedTaskRetries, List<? extends ScheduledTaskType> updateType) {
        return this.datastore.aggregate(ScheduledTask.class).match(new Filter[]{Filters.eq((String)"hasBeenProcessed", (Object)false), Filters.in((String)"updateType", (Iterable)updateType.stream().map(ScheduledTaskType::getValue).collect(Collectors.toList()))}).lookup(Lookup.from(FailedTask.class).localField("entityId").foreignField("entityId").as("failed_tasks_lookup")).unwind(Unwind.on((String)"failed_tasks_lookup")).match(new Filter[]{Filters.gte((String)"failed_tasks_lookup.failureCount", (Object)maxFailedTaskRetries)}).project(Projection.of().include("entityId")).execute(ScheduledTask.class);
    }
}

