/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web;

import eu.europeana.api.commons.error.EuropeanaApiErrorResponse;
import eu.europeana.api.commons.error.EuropeanaGlobalExceptionHandler;
import eu.europeana.api.commons.web.exception.HttpException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class EMExceptionHandler
extends EuropeanaGlobalExceptionHandler {
    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleCommonHttpException(HttpException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(e.getStatus().value()).setError(e.getStatus().getReasonPhrase()).setMessage(e.getMessage()).setCode(e.getI18nKey()).build();
        return ResponseEntity.status((HttpStatus)e.getStatus()).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }

    @ExceptionHandler
    public ResponseEntity<EuropeanaApiErrorResponse> handleException(HttpMessageNotReadableException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(HttpStatus.BAD_REQUEST.value()).setError("Error parsing request body").setMessage("JSON is either malformed or missing required 'type' property").build();
        return ResponseEntity.status((int)HttpStatus.BAD_REQUEST.value()).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleMethodArgNotValidException(MethodArgumentNotValidException e, HttpServletRequest httpRequest) {
        BindingResult result = e.getBindingResult();
        Object error = "";
        List fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            error = ((FieldError)fieldErrors.get(0)).getField() + " " + ((FieldError)fieldErrors.get(0)).getDefaultMessage();
        }
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(HttpStatus.BAD_REQUEST.value()).setMessage("Invalid request body").setError((String)error).build();
        return ResponseEntity.status((int)response.getStatus()).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }

    @ExceptionHandler(value={HttpMediaTypeException.class})
    public ResponseEntity<EuropeanaApiErrorResponse> handleInvalidMediaType(HttpMediaTypeException e, HttpServletRequest httpRequest) {
        EuropeanaApiErrorResponse response = new EuropeanaApiErrorResponse.Builder(httpRequest, (Exception)e, this.stackTraceEnabled()).setStatus(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value()).setError(e.getMessage()).setMessage("Unsupported media type. Supported types are: " + MediaType.toString((Collection)e.getSupportedMediaTypes())).build();
        return ResponseEntity.status((int)HttpStatus.UNSUPPORTED_MEDIA_TYPE.value()).contentType(MediaType.APPLICATION_JSON).body((Object)response);
    }
}

