/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import eu.europeana.corelib.edm.utils.JsonLdSerializer;
import eu.europeana.entitymanagement.definitions.mixins.ConsolidatedAgentMixin;
import eu.europeana.entitymanagement.definitions.model.ConsolidatedAgent;
import eu.europeana.entitymanagement.web.xml.model.RdfBaseWrapper;
import eu.europeana.entitymanagement.web.xml.model.WikidataOrganization;
import eu.europeana.entitymanagement.web.xml.model.metis.EnrichmentResultList;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class SerializationConfig {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX");

    @Primary
    @Bean(value={"emJsonMapper"})
    public ObjectMapper mapper() {
        ObjectMapper mapper = new Jackson2ObjectMapperBuilder().defaultUseWrapper(false).dateFormat(this.dateFormat).featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).serializationInclusion(JsonInclude.Include.NON_NULL).mixIn(ConsolidatedAgent.class, ConsolidatedAgentMixin.class).build();
        mapper.findAndRegisterModules();
        return mapper;
    }

    @Bean(value={"emXmlMapper"})
    public XmlMapper xmlMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.setDateFormat(this.dateFormat);
        return xmlMapper;
    }

    @Bean
    public Module jaxbAnnotationModule() {
        return new JaxbAnnotationModule();
    }

    @Bean
    public JAXBContext jaxbContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{EnrichmentResultList.class, RdfBaseWrapper.class, WikidataOrganization.class});
    }

    @Bean
    public JsonLdSerializer corelibJsonLdSerializer() {
        return new JsonLdSerializer();
    }
}

