/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.processor;

import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import java.util.Set;
import org.springframework.batch.item.ItemProcessor;

public abstract class BaseEntityProcessor
implements ItemProcessor<BatchEntityRecord, BatchEntityRecord> {
    private final Set<ScheduledTaskType> supportedScheduledTasks;

    protected BaseEntityProcessor(ScheduledTaskType ... supportedScheduledTasks) {
        this.supportedScheduledTasks = Set.of(supportedScheduledTasks);
    }

    private boolean shouldProcessUpdateType(ScheduledTaskType updateType) {
        return this.supportedScheduledTasks.contains(updateType);
    }

    abstract BatchEntityRecord doProcessing(BatchEntityRecord var1) throws Exception;

    public BatchEntityRecord process(BatchEntityRecord item) throws Exception {
        if (!this.shouldProcessUpdateType(item.getScheduledTaskType())) {
            return item;
        }
        return this.doProcessing(item);
    }
}

