/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.config;

import eu.europeana.entitymanagement.batch.config.EntityUpdateJobConfig;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledRemovalType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:entitymanagement.properties"}), @PropertySource(value={"classpath:entitymanagement.user.properties"}, ignoreResourceNotFound=true)})
@EnableScheduling
public class EntityUpdateSchedulingConfig
implements InitializingBean {
    private static final Logger logger = LogManager.getLogger(EntityUpdateSchedulingConfig.class);
    private final JobLauncher entityUpdateJobLauncher;
    private final JobLauncher entityDeletionsJobLauncher;
    private final EntityUpdateJobConfig updateJobConfig;
    private final TaskScheduler updatesScheduler;
    private final TaskScheduler removalsScheduler;
    @Value(value="${batch.scheduling.update.initialDelaySeconds}")
    private long updateInitialDelay;
    @Value(value="${batch.scheduling.deprecation-deletion.initialDelaySeconds}")
    private long deprecationDeletionInitialDelay;
    @Value(value="${batch.scheduling.intervalSeconds}")
    private long interval;
    @Value(value="${batch.scheduling.enabled}")
    private boolean syncEnabled;

    public EntityUpdateSchedulingConfig(@Qualifier(value="entityUpdateJobLauncher") JobLauncher entityUpdateJobLauncher, @Qualifier(value="entityRemovalsJobLauncher") JobLauncher entityDeletionsJobLauncher, EntityUpdateJobConfig batchUpdateConfig, @Qualifier(value="periodicUpdatesScheduler") TaskScheduler updatesScheduler, @Qualifier(value="periodicRemovalsScheduler") TaskScheduler removalsScheduler) {
        this.entityUpdateJobLauncher = entityUpdateJobLauncher;
        this.entityDeletionsJobLauncher = entityDeletionsJobLauncher;
        this.updateJobConfig = batchUpdateConfig;
        this.updatesScheduler = updatesScheduler;
        this.removalsScheduler = removalsScheduler;
    }

    public void afterPropertiesSet() {
        if (this.syncEnabled) {
            String updateInitialDelayString = this.toMinutesAndSeconds(this.updateInitialDelay);
            String deprecationDeletionInitialDelayString = this.toMinutesAndSeconds(this.deprecationDeletionInitialDelay);
            String intervalString = this.toMinutesAndSeconds(this.interval);
            logger.info("Batch scheduling initialized \u2013 updateInitialDelay: {}; deprecationDeletionInitialDelay: {}interval: {}", (Object)updateInitialDelayString, (Object)deprecationDeletionInitialDelayString, (Object)intervalString);
            this.schedulePeriodicUpdates();
            this.schedulePeriodicDeprecationsAndDeletions();
        } else {
            logger.warn("Batch scheduling disabled. Entities will not be automatically updated.");
        }
    }

    private void schedulePeriodicDeprecationsAndDeletions() {
        this.removalsScheduler.scheduleWithFixedDelay(this::runScheduledDeprecationsAndDeletions, Instant.now().plusSeconds(this.deprecationDeletionInitialDelay), Duration.ofSeconds(this.interval));
    }

    private void schedulePeriodicUpdates() {
        this.updatesScheduler.scheduleWithFixedDelay(this::runScheduledUpdate, Instant.now().plusSeconds(this.updateInitialDelay), Duration.ofSeconds(this.interval));
    }

    @Async
    void runScheduledUpdate() {
        logger.info("Triggering scheduled full and metrics update for entities");
        try {
            this.entityUpdateJobLauncher.run(this.updateJobConfig.updateScheduledEntities(List.of(ScheduledUpdateType.FULL_UPDATE, ScheduledUpdateType.METRICS_UPDATE)), BatchUtils.createJobParameters(null, Date.from(Instant.now()), List.of(ScheduledUpdateType.FULL_UPDATE, ScheduledUpdateType.METRICS_UPDATE), false));
        }
        catch (Exception e) {
            logger.warn("Error running scheduled full and metrics update", (Throwable)e);
        }
    }

    @Async
    void runScheduledDeprecationsAndDeletions() {
        logger.info("Triggering scheduled deprecations and deletions for entities");
        try {
            this.entityDeletionsJobLauncher.run(this.updateJobConfig.removeScheduledEntities(List.of(ScheduledRemovalType.PERMANENT_DELETION, ScheduledRemovalType.DEPRECATION)), BatchUtils.createJobParameters(null, Date.from(Instant.now()), List.of(ScheduledRemovalType.PERMANENT_DELETION, ScheduledRemovalType.DEPRECATION), false));
        }
        catch (Exception e) {
            logger.warn("Error running scheduled deprecations and deletions", (Throwable)e);
        }
    }

    private String toMinutesAndSeconds(long seconds) {
        return String.format("%d min, %d sec", TimeUnit.SECONDS.toMinutes(seconds), seconds - TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(seconds)));
    }
}

