/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import eu.europeana.api.commons.definitions.vocabulary.Role;
import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.api.commons.service.authorization.AuthorizationService;
import eu.europeana.api.commons.service.authorization.BaseAuthorizationService;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.web.auth.Roles;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.stereotype.Component;

@Component(value="authorizationService")
public class EMAuthorizationService
extends BaseAuthorizationService
implements AuthorizationService {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final EntityManagementConfiguration emConfiguration;
    private final EuropeanaClientDetailsService clientDetailsService;

    @Autowired
    public EMAuthorizationService(EntityManagementConfiguration emConfiguration, EuropeanaClientDetailsService clientDetailsService) {
        this.emConfiguration = emConfiguration;
        this.clientDetailsService = clientDetailsService;
    }

    protected ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    protected String getSignatureKey() {
        return this.emConfiguration.getApiKeyPublicKey();
    }

    protected String getApiName() {
        return this.emConfiguration.getAuthorizationApiName();
    }

    protected Role getRoleByName(String name) {
        return Roles.getRoleByName((String)name);
    }
}

