/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.model;

import com.zoho.crm.api.record.Record;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import java.util.Date;

public class Operation
implements Comparable<Operation> {
    private String action;
    private String organizationId;
    private Record zohoRecord;
    private Date modified;
    EntityRecord entityRecord;

    public Operation(String organizationId, String action, Record zohoRecord, EntityRecord entityRecord) {
        this.organizationId = organizationId;
        this.action = action;
        this.zohoRecord = zohoRecord;
        this.modified = zohoRecord != null ? new Date(zohoRecord.getModifiedTime().toInstant().toEpochMilli()) : new Date();
        this.entityRecord = entityRecord;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public int hashCode() {
        if (this.getOrganizationId() == null) {
            return -1;
        }
        return this.getOrganizationId().hashCode();
    }

    public String toString() {
        return String.format("organizationId: %s, action: %s", this.getOrganizationId(), this.getAction());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation op2 = (Operation)obj;
        return this.getOrganizationId().equals(op2.getOrganizationId()) && this.getAction().equals(op2.getAction());
    }

    @Override
    public int compareTo(Operation o) {
        int ret = this.getModified().compareTo(o.getModified());
        if (ret == 0) {
            ret = this.getOrganizationId().compareTo(o.getOrganizationId());
        }
        return ret;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Record getZohoRecord() {
        return this.zohoRecord;
    }

    public EntityRecord getEntityRecord() {
        return this.entityRecord;
    }
}

