/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.model;

import eu.europeana.entitymanagement.exception.FunctionalRuntimeException;
import eu.europeana.entitymanagement.web.model.Operation;
import java.util.SortedSet;
import java.util.TreeSet;

public class BatchOperations {
    private SortedSet<Operation> createOperations;
    private SortedSet<Operation> enableOperations;
    private SortedSet<Operation> updateOperations;
    private SortedSet<Operation> deleteOperations;
    private SortedSet<Operation> permanentDeleteOperations;

    public SortedSet<Operation> getCreateOperations() {
        return this.createOperations;
    }

    public SortedSet<Operation> getEnableOperations() {
        return this.enableOperations;
    }

    public SortedSet<Operation> getUpdateOperations() {
        return this.updateOperations;
    }

    public SortedSet<Operation> getDeleteOperations() {
        return this.deleteOperations;
    }

    public SortedSet<Operation> getPermanentDeleteOperations() {
        return this.permanentDeleteOperations;
    }

    public void addOperation(Operation operation) {
        switch (operation.getAction()) {
            case "create": {
                if (this.createOperations == null) {
                    this.createOperations = new TreeSet();
                }
                this.createOperations.add(operation);
                break;
            }
            case "enable": {
                if (this.enableOperations == null) {
                    this.enableOperations = new TreeSet();
                }
                this.enableOperations.add(operation);
                break;
            }
            case "update": {
                if (this.updateOperations == null) {
                    this.updateOperations = new TreeSet();
                }
                this.updateOperations.add(operation);
                break;
            }
            case "delete": {
                if (this.deleteOperations == null) {
                    this.deleteOperations = new TreeSet();
                }
                this.deleteOperations.add(operation);
                break;
            }
            case "perm_delete": {
                if (this.permanentDeleteOperations == null) {
                    this.permanentDeleteOperations = new TreeSet();
                }
                this.permanentDeleteOperations.add(operation);
                break;
            }
            default: {
                throw new FunctionalRuntimeException("Unsuported zoho sync operation: " + operation.getAction());
            }
        }
    }
}

