/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import eu.europeana.batch.config.MongoBatchConfigurer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;

@Configuration
public class JobLauncherConfig {
    private final MongoBatchConfigurer mongoBatchConfigurer;
    private final TaskExecutor synchronousWebRequestExecutor;
    private final TaskExecutor deletionsTaskExecutor;

    public JobLauncherConfig(MongoBatchConfigurer mongoBatchConfigurer, @Qualifier(value="webRequestTaskExecutor") TaskExecutor webRequestJobExecutor, @Qualifier(value="scheduledRemovalTaskExecutor") TaskExecutor deletionsTaskExecutor) {
        this.mongoBatchConfigurer = mongoBatchConfigurer;
        this.synchronousWebRequestExecutor = webRequestJobExecutor;
        this.deletionsTaskExecutor = deletionsTaskExecutor;
    }

    @Bean(name={"entityUpdateJobLauncher"})
    @Primary
    public JobLauncher defaultJobLauncher() throws Exception {
        return this.mongoBatchConfigurer.getJobLauncher();
    }

    @Bean(value={"entityRemovalsJobLauncher"})
    public JobLauncher entityDeletionJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.mongoBatchConfigurer.getJobRepository());
        jobLauncher.setTaskExecutor(this.deletionsTaskExecutor);
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    @Bean(name={"synchronousWebRequestJobLauncher"})
    public JobLauncher synchronousJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.mongoBatchConfigurer.getJobRepository());
        jobLauncher.setTaskExecutor(this.synchronousWebRequestExecutor);
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }
}

