/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import java.util.Collections;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    private final BuildProperties buildInfo;
    private final GitProperties gitProperties;

    public SwaggerConfig(BuildProperties buildInfo, GitProperties gitProperties) {
        this.buildInfo = buildInfo;
        this.gitProperties = gitProperties;
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"eu.europeana.entitymanagement")).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfo(this.buildInfo.get("project.name"), this.buildInfo.get("project.description"), this.buildInfo.getVersion() + "(build " + this.gitProperties.get("commit.id.abbrev") + ")", null, new Contact("API team", "https://api.europeana.eu", "api@europeana.eu"), "EUPL 1.2", "https://www.eupl.eu", Collections.emptyList());
    }
}

