/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.exception.ScoringComputationException;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.model.EnrichmentCountResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class EnrichmentCountQueryService {
    private static final Map<String, String> ENRICHMENT_QUERY_FIELD_MAP = Map.of(EntityTypes.Agent.getEntityType(), "edm_agent", EntityTypes.Concept.getEntityType(), "skos_concept", EntityTypes.Place.getEntityType(), "edm_place", EntityTypes.TimeSpan.getEntityType(), "edm_timespan", EntityTypes.Organization.getEntityType(), "foaf_organization");
    private static final Logger logger = LogManager.getLogger(EnrichmentCountQueryService.class);
    private static final String ERROR_MSG = "Error retrieving enrichmentCount for entityId=";
    private static final String contentTierPrefix = " AND contentTier:";
    private final WebClient webClient;
    private final EntityManagementConfiguration configuration;

    public EnrichmentCountQueryService(EntityManagementConfiguration configuration) {
        this.configuration = configuration;
        this.webClient = WebClient.builder().build();
    }

    public int getEnrichmentCount(String entityId, String type) {
        EnrichmentCountResponse response;
        String uri = this.buildSearchRequestUrl(entityId, type);
        if (logger.isDebugEnabled()) {
            logger.debug("Getting enrichment count for entityId={}; queryUri={}", (Object)entityId, (Object)uri);
        }
        Instant start = Instant.now();
        try {
            response = (EnrichmentCountResponse)this.webClient.get().uri(uri, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono(EnrichmentCountResponse.class).block();
        }
        catch (Exception e) {
            throw new ScoringComputationException(ERROR_MSG + entityId, e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved enrichmentCount for entityId={} in {}ms; response={}", (Object)entityId, (Object)Duration.between(start, Instant.now()).toMillis(), (Object)response);
        }
        if (response == null) {
            throw new ScoringComputationException(ERROR_MSG + entityId);
        }
        return response.getTotalResults();
    }

    String buildSearchRequestUrl(String entityId, String type) {
        StringBuilder url = new StringBuilder(this.configuration.getSearchApiUrlPrefix());
        String searchQuery = String.format("%s:%s ", ENRICHMENT_QUERY_FIELD_MAP.get(type), this.getEntityIdForQuery(entityId, type));
        url.append("&query=" + searchQuery);
        if (!EntityTypes.Organization.getEntityType().equals(type)) {
            url.append(contentTierPrefix);
            url.append(this.configuration.getEnrichmentsQueryContentTier());
        }
        url.append("&profile=minimal");
        url.append("&rows=0");
        return url.toString();
    }

    private String getEntityIdForQuery(String entityId, String type) {
        if (EntityTypes.TimeSpan.getEntityType().equals(type) || EntityTypes.Organization.getEntityType().equals(type)) {
            return "\"" + entityId + "\"";
        }
        StringBuilder entityIdsBuilder = new StringBuilder("(\"");
        entityIdsBuilder.append("http://data.europeana.eu/").append(EntityRecordUtils.getEntityRequestPathWithBase((String)entityId)).append("\" OR \"").append("http://data.europeana.eu/").append(EntityRecordUtils.getEntityRequestPath((String)entityId)).append("\")");
        return entityIdsBuilder.toString();
    }
}

