/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.entitymanagement.definitions.batch.model.FailedTask;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.serialization.SerializationUtils;
import eu.europeana.entitymanagement.vocabulary.EntityProfile;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="emJsonldSerializer")
public class JsonLdSerializer {
    private final ObjectMapper mapper;
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @Autowired
    public JsonLdSerializer(@Qualifier(value="emJsonMapper") ObjectMapper objectMapper) {
        this.mapper = objectMapper.copy();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        this.mapper.setDateFormat((DateFormat)df);
    }

    public String serialize(EntityRecord record, List<EntityProfile> profiles, boolean includeFailure, Optional<FailedTask> failure) throws IOException {
        String response = profiles.contains(EntityProfile.internal) ? SerializationUtils.serializeInternalJson(this.mapper, record, includeFailure, failure) : SerializationUtils.serializeExternalJson(this.mapper, record, includeFailure, failure);
        return response;
    }

    public String serializeEntities(List<EntityRecord> entityRecords) throws IOException {
        return SerializationUtils.serializeExternalJson(this.mapper, entityRecords);
    }

    public String serializeFailedUpdates(List<String> pathUrls) throws IOException {
        return this.mapper.writeValueAsString(pathUrls);
    }

    public String serializeObject(Object obj) throws IOException {
        return this.mapper.writeValueAsString(obj);
    }
}

