/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.service;

import eu.europeana.entitymanagement.batch.config.EntityUpdateJobConfig;
import eu.europeana.entitymanagement.batch.service.ScheduledTaskService;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EntityUpdateService {
    private static final Logger logger = LogManager.getLogger(EntityUpdateService.class);
    private final EntityUpdateJobConfig entityUpdateJobConfig;
    private final JobLauncher syncWebRequestLauncher;
    private final ScheduledTaskService scheduledTaskService;

    @Autowired
    public EntityUpdateService(EntityUpdateJobConfig entityUpdateJobConfig, @Qualifier(value="synchronousWebRequestJobLauncher") JobLauncher syncWebRequestLauncher, ScheduledTaskService scheduledTaskService) {
        this.entityUpdateJobConfig = entityUpdateJobConfig;
        this.scheduledTaskService = scheduledTaskService;
        this.syncWebRequestLauncher = syncWebRequestLauncher;
    }

    public void runSynchronousUpdate(String entityId) throws Exception {
        logger.debug("Triggering synchronous update for entityId={}", (Object)entityId);
        this.syncWebRequestLauncher.run(this.entityUpdateJobConfig.updateSingleEntity(), BatchUtils.createJobParameters(entityId, Date.from(Instant.now()), List.of(ScheduledUpdateType.FULL_UPDATE), true));
    }

    public void scheduleTasks(List<String> entityIds, ScheduledTaskType updateType) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return;
        }
        logger.info("Scheduling async task for entityIds={}, count={} updateType={}", (Object)Arrays.toString(entityIds.toArray()), (Object)entityIds.size(), (Object)updateType);
        HashMap<String, ScheduledTaskType> mapEntityIdScheduledTaskType = new HashMap<String, ScheduledTaskType>(entityIds.size());
        for (String id : entityIds) {
            mapEntityIdScheduledTaskType.put(id, updateType);
        }
        this.scheduledTaskService.scheduleTasksForEntities(mapEntityIdScheduledTaskType);
    }
}

