/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import dev.morphia.Datastore;
import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.batch.config.MongoBatchConfigurer;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.common.vocabulary.AppConfigConstants;
import eu.europeana.entitymanagement.config.DataSources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.web.filter.ShallowEtagHeaderFilter;

@Configuration
public class AppConfig
extends AppConfigConstants {
    private static final Logger LOG = LogManager.getLogger(AppConfig.class);
    @Resource
    private EntityManagementConfiguration emConfiguration;
    @Resource(name="emXmlMapper")
    private XmlMapper xmlMapper;
    @Resource(name="scheduledUpdateTaskExecutor")
    private TaskExecutor defaultTaskExecutor;

    public AppConfig() {
        LOG.info("Initializing EntityManagementConfiguration bean as: configuration");
    }

    @PostConstruct
    public void init() {
        String jwtTokenSignatureKey;
        if ((this.emConfiguration.isAuthReadEnabled() || this.emConfiguration.isAuthWriteEnabled()) && ((jwtTokenSignatureKey = this.emConfiguration.getApiKeyPublicKey()) == null || jwtTokenSignatureKey.isBlank())) {
            throw new IllegalStateException("The jwt token signature key cannot be null or empty.");
        }
    }

    @Bean(name={"emDataSources"})
    public DataSources getDataSources() throws IOException {
        DataSources dataSources;
        String datasourcesXMLConfigFile = this.emConfiguration.getDatasourcesXMLConfig();
        try (InputStream inputStream = this.getClass().getResourceAsStream(datasourcesXMLConfigFile);){
            assert (inputStream != null);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String contents = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                dataSources = (DataSources)this.xmlMapper.readValue(contents, DataSources.class);
            }
        }
        if (dataSources.getEuropeanaDatasource().isEmpty()) {
            throw new IllegalStateException(String.format("Datasource must be configured with id='%s' in %s", "europeana", datasourcesXMLConfigFile));
        }
        return dataSources;
    }

    @Bean(name={"clientDetailsService"})
    public EuropeanaClientDetailsService getClientDetailsService() {
        EuropeanaClientDetailsService clientDetailsService = new EuropeanaClientDetailsService();
        clientDetailsService.setApiKeyServiceUrl(this.emConfiguration.getApiKeyUrl());
        return clientDetailsService;
    }

    @Bean
    public MongoBatchConfigurer mongoBatchConfigurer(@Qualifier(value="batchDataStore") Datastore datastore) {
        return new MongoBatchConfigurer(datastore, this.defaultTaskExecutor);
    }

    @Bean
    public ShallowEtagHeaderFilter shallowEtagHeaderFilter() {
        return new ShallowEtagHeaderFilter();
    }
}

