/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.reader;

import dev.morphia.query.experimental.filters.Filter;
import eu.europeana.entitymanagement.batch.reader.BaseDatabaseReader;
import eu.europeana.entitymanagement.batch.service.ScheduledTaskService;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public class ScheduledTaskDatabaseReader
extends BaseDatabaseReader<BatchEntityRecord> {
    private static final Logger logger = LogManager.getLogger(ScheduledTaskDatabaseReader.class);
    private final ScheduledTaskService scheduledTaskService;
    private final Filter[] scheduledTaskFilter;

    public ScheduledTaskDatabaseReader(ScheduledTaskService scheduledTaskService, int pageSize, Filter ... scheduledTaskFilter) {
        super(pageSize);
        this.scheduledTaskService = scheduledTaskService;
        this.scheduledTaskFilter = scheduledTaskFilter;
    }

    @NonNull
    protected Iterator<BatchEntityRecord> doPageRead() {
        int start = this.page * this.pageSize;
        List entityRecords = this.scheduledTaskService.getEntityRecordsForTasks(start, this.pageSize, this.scheduledTaskFilter);
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved {} scheduled entities from database. skip={}, limit={}, entityIds={}", (Object)entityRecords.size(), (Object)start, (Object)this.pageSize, (Object)Arrays.toString(BatchUtils.getEntityIds((List)entityRecords)));
        }
        return entityRecords.iterator();
    }

    String getClassName() {
        return ScheduledTaskDatabaseReader.class.getSimpleName();
    }
}

