/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.reader;

import dev.morphia.query.experimental.filters.Filter;
import eu.europeana.entitymanagement.batch.reader.BaseDatabaseReader;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.batch.ScheduledTaskUtils;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public class EntityRecordDatabaseReader
extends BaseDatabaseReader<BatchEntityRecord> {
    private static final Logger logger = LogManager.getLogger(EntityRecordDatabaseReader.class);
    private final EntityRecordService entityRecordService;
    private final Filter[] queryFilters;
    private final ScheduledTaskType scheduledTaskType;

    public EntityRecordDatabaseReader(String scheduledTaskType, EntityRecordService entityRecordService, int pageSize, Filter ... queryFilters) {
        super(pageSize);
        this.scheduledTaskType = ScheduledTaskUtils.scheduledTaskTypeValueOf((String)scheduledTaskType);
        this.entityRecordService = entityRecordService;
        this.queryFilters = queryFilters;
    }

    @NonNull
    protected Iterator<BatchEntityRecord> doPageRead() {
        int start = this.page * this.pageSize;
        List result = this.entityRecordService.findEntitiesWithFilter(start, this.pageSize, this.queryFilters);
        List batchEntityRecords = result.stream().map(p -> new BatchEntityRecord(p, this.scheduledTaskType)).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved {} EntityRecords from database. skip={}, limit={}, entityIds={}", (Object)result.size(), (Object)start, (Object)this.pageSize, (Object)Arrays.toString(BatchUtils.getEntityIds(batchEntityRecords)));
        }
        return batchEntityRecords.iterator();
    }

    String getClassName() {
        return EntityRecordDatabaseReader.class.getSimpleName();
    }
}

