/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.processor;

import eu.europeana.entitymanagement.batch.processor.BaseEntityProcessor;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.exception.FunctionalRuntimeException;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.web.model.scoring.EntityMetrics;
import eu.europeana.entitymanagement.web.service.ScoringService;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class EntityMetricsProcessor
extends BaseEntityProcessor {
    private final ScoringService scoringService;
    private final EntityManagementConfiguration entityManagementConfiguration;
    private static final Logger logger = LogManager.getLogger(EntityMetricsProcessor.class);

    public EntityMetricsProcessor(ScoringService scoringService, EntityManagementConfiguration entityManagementConfiguration) {
        super(new ScheduledTaskType[]{ScheduledUpdateType.FULL_UPDATE, ScheduledUpdateType.METRICS_UPDATE});
        this.scoringService = scoringService;
        this.entityManagementConfiguration = entityManagementConfiguration;
    }

    public BatchEntityRecord doProcessing(BatchEntityRecord entityRecord) throws Exception {
        Date now = new Date();
        if (entityRecord.getEntityRecord().getEntity().getIsAggregatedBy() == null) {
            Aggregation aggregation = new Aggregation();
            aggregation.setCreated(now);
            entityRecord.getEntityRecord().getEntity().setIsAggregatedBy(aggregation);
        }
        if (this.entityManagementConfiguration.shouldComputeMetrics()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Computing ranking metrics for entityId={}", (Object)entityRecord.getEntityRecord().getEntityId());
            }
            this.computeRankingMetrics(entityRecord.getEntityRecord());
        }
        entityRecord.getEntityRecord().getEntity().getIsAggregatedBy().setModified(now);
        return entityRecord;
    }

    private void computeRankingMetrics(EntityRecord entityRecord) throws EntityUpdateException {
        EntityMetrics metrics;
        Entity entity = entityRecord.getEntity();
        if (entity == null) {
            throw new EntityUpdateException("An entity object needs to be available in EntityRecord in order to compute the scoring metrics!");
        }
        try {
            metrics = this.scoringService.computeMetrics(entity);
        }
        catch (UnsupportedEntityTypeException | FunctionalRuntimeException e) {
            throw new EntityUpdateException("Cannot compute ranking metrics for entityId=" + entity.getEntityId(), e);
        }
        Aggregation aggregation = entity.getIsAggregatedBy();
        aggregation.setPageRank(Double.valueOf(metrics.getPageRank()));
        aggregation.setRecordCount(Integer.valueOf(metrics.getEnrichmentCount()));
        aggregation.setScore(Integer.valueOf(metrics.getScore()));
    }
}

