/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.listener;

import eu.europeana.entitymanagement.batch.service.FailedTaskService;
import eu.europeana.entitymanagement.batch.service.ScheduledTaskService;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.batch.model.BatchEntityRecord;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.listener.ItemListenerSupport;
import org.springframework.lang.NonNull;

public class ScheduledTaskItemListener
extends ItemListenerSupport<BatchEntityRecord, BatchEntityRecord> {
    private static final Logger logger = LogManager.getLogger(ScheduledTaskItemListener.class);
    private final FailedTaskService failedTaskService;
    private final ScheduledTaskService scheduledTaskService;
    private final boolean isSynchronous;

    public ScheduledTaskItemListener(FailedTaskService failedTaskService, ScheduledTaskService scheduledTaskService, boolean isSynchronous) {
        this.failedTaskService = failedTaskService;
        this.scheduledTaskService = scheduledTaskService;
        this.isSynchronous = isSynchronous;
    }

    public void afterWrite(@NonNull List<? extends BatchEntityRecord> entityRecords) {
        if (entityRecords.isEmpty()) {
            return;
        }
        Object[] entityIds = BatchUtils.getEntityIds(entityRecords);
        if (logger.isDebugEnabled()) {
            logger.debug("afterWrite: entityIds={}, count={};", (Object)Arrays.toString(entityIds), (Object)entityIds.length);
        }
        this.failedTaskService.removeFailures(Arrays.asList(entityIds));
        if (!this.isSynchronous) {
            this.scheduledTaskService.markAsProcessed(entityRecords.stream().collect(Collectors.toMap(p -> p.getEntityRecord().getEntityId(), p -> p.getScheduledTaskType())));
        }
    }

    public void onReadError(@NonNull Exception e) {
        logger.warn("onReadError", (Throwable)e);
    }

    public void onProcessError(@NonNull BatchEntityRecord entityRecord, @NonNull Exception e) {
        String entityId = entityRecord.getEntityRecord().getEntityId();
        logger.warn("onProcessError: entityId={}", (Object)entityId, (Object)e);
        this.failedTaskService.persistFailure(entityId, entityRecord.getScheduledTaskType(), e);
    }

    public void onWriteError(@NonNull Exception e, @NonNull List<? extends BatchEntityRecord> entityRecords) {
        String[] entityIds = BatchUtils.getEntityIds(entityRecords);
        logger.warn("onWriteError: entityIds={}", (Object)entityIds, (Object)e);
        this.failedTaskService.persistFailureBulk(entityRecords.stream().collect(Collectors.toMap(r -> r.getEntityRecord().getEntityId(), r -> r.getScheduledTaskType())), e);
    }
}

