/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import com.zoho.crm.api.record.DeletedRecord;
import com.zoho.crm.api.record.Record;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import eu.europeana.entitymanagement.batch.service.EntityUpdateService;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import eu.europeana.entitymanagement.definitions.exceptions.EntityCreationException;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.exception.FunctionalRuntimeException;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.mongo.repository.EntityRecordRepository;
import eu.europeana.entitymanagement.solr.exception.SolrServiceException;
import eu.europeana.entitymanagement.solr.service.SolrService;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.model.BatchOperations;
import eu.europeana.entitymanagement.web.model.Operation;
import eu.europeana.entitymanagement.web.model.ZohoSyncReport;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import eu.europeana.entitymanagement.zoho.organization.ZohoAccessConfiguration;
import eu.europeana.entitymanagement.zoho.organization.ZohoOrganizationConverter;
import eu.europeana.entitymanagement.zoho.utils.ZohoException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="emZohoSyncService")
public class ZohoSyncService {
    private final EntityRecordService entityRecordService;
    private final EntityRecordRepository entityRecordRepository;
    private final EntityUpdateService entityUpdateService;
    final EntityManagementConfiguration emConfiguration;
    private final DataSources datasources;
    private final DataSource zohoDataSource;
    private final ZohoAccessConfiguration zohoAccessConfiguration;
    private static final Logger logger = LogManager.getLogger(ZohoSyncService.class);

    @Autowired
    public ZohoSyncService(EntityRecordService entityRecordService, EntityUpdateService entityUpdateService, EntityRecordRepository entityRecordRepository, EntityManagementConfiguration emConfiguration, DataSources datasources, ZohoAccessConfiguration zohoAccessConfiguration, SolrService solrService) {
        this.entityRecordService = entityRecordService;
        this.entityUpdateService = entityUpdateService;
        this.entityRecordRepository = entityRecordRepository;
        this.emConfiguration = emConfiguration;
        this.datasources = datasources;
        this.zohoAccessConfiguration = zohoAccessConfiguration;
        this.zohoDataSource = this.initZohoDataSource();
    }

    private DataSource initZohoDataSource() {
        Optional<DataSource> zohoDatasource = this.datasources.getDatasourceById("zoho-crm");
        if (zohoDatasource.isEmpty()) {
            throw new FunctionalRuntimeException("No zoho data source found! Zoho data source must be present in configurations with id: zoho-crm");
        }
        return zohoDatasource.get();
    }

    public ZohoSyncReport synchronizeZohoOrganizations(@NotNull OffsetDateTime modifiedSince) throws EntityUpdateException {
        ZohoSyncReport zohoSyncReport = new ZohoSyncReport(new Date());
        this.synchronizeZohoOrganizations(modifiedSince, zohoSyncReport);
        this.synchronizeDeletedZohoOrganizations(modifiedSince, zohoSyncReport);
        return zohoSyncReport;
    }

    void synchronizeZohoOrganizations(@NotNull OffsetDateTime modifiedSince, ZohoSyncReport zohoSyncReport) {
        int page = 1;
        int pageSize = this.emConfiguration.getZohoSyncBatchSize();
        boolean hasNext = true;
        while (hasNext) {
            List orgList;
            try {
                orgList = this.zohoAccessConfiguration.getZohoAccessClient().getZcrmRecordOrganizations(page, pageSize, modifiedSince);
                this.logExecutionProgress(orgList, page, pageSize);
            }
            catch (ZohoException e) {
                zohoSyncReport.addFailedOperation(null, "Zoho access error", "Zoho synchronization exception occured when handling organizations modified in Zoho, the execution was interupted without updating all organizations", e);
                return;
            }
            BatchOperations operations = this.fillOperations(orgList);
            this.performOperations(operations, zohoSyncReport);
            if (this.isLastPage(orgList.size(), pageSize)) {
                hasNext = false;
                continue;
            }
            ++page;
        }
        logger.info("Zoho update operations completed successfully:\n {}", (Object)zohoSyncReport);
    }

    void synchronizeDeletedZohoOrganizations(OffsetDateTime modifiedSince, ZohoSyncReport zohoSyncReport) throws EntityUpdateException {
        int startPage = 1;
        int pageSize = this.emConfiguration.getZohoSyncBatchSize();
        boolean hasNext = true;
        int currentPageSize = 0;
        List<String> entitiesDeletedInZoho = null;
        while (hasNext) {
            try {
                List deletedRecordsInZoho = this.zohoAccessConfiguration.getZohoAccessClient().getZohoDeletedRecordOrganizations(modifiedSince, startPage, pageSize);
                currentPageSize = deletedRecordsInZoho.size();
                entitiesDeletedInZoho = this.getDeletedEntityIds(deletedRecordsInZoho);
                this.runPermanentDelete(entitiesDeletedInZoho, zohoSyncReport);
            }
            catch (ZohoException e) {
                logger.error("Zoho synchronization exception occured when handling organizations deleted in Zoho", (Throwable)e);
                zohoSyncReport.addFailedOperation(null, "Zoho access error", e);
            }
            catch (SolrServiceException | RuntimeException e) {
                logger.error("Zoho synchronization exception occured when handling organizations deleted in Zoho", e);
                String message = this.buildErrorMessage("Unexpected error occured when deleting organizations with ids: ", entitiesDeletedInZoho);
                zohoSyncReport.addFailedOperation(null, "Entity deletion error", message, e);
            }
            if (this.isLastPage(currentPageSize, pageSize)) {
                hasNext = false;
                continue;
            }
            ++startPage;
        }
    }

    String buildErrorMessage(String message, List<String> ids) {
        if (ids != null) {
            StringBuilder builder = new StringBuilder(message);
            builder.append(ids);
            message = builder.toString();
        }
        return message;
    }

    void logExecutionProgress(List<Record> orgList, int page, int pageSize) {
        int start = (page - 1) * pageSize;
        int end = start + orgList.size();
        logger.info("Processing organizations set: {} - {}", (Object)start, (Object)end);
    }

    private void performOperations(BatchOperations operations, ZohoSyncReport zohoSyncReport) {
        SortedSet<Operation> createOperations = operations.getCreateOperations();
        this.performCreateOperations(createOperations, zohoSyncReport);
        SortedSet<Operation> enableOperations = operations.getEnableOperations();
        this.performEnableOperations(enableOperations, zohoSyncReport);
        this.performUpdateOperations(operations.getUpdateOperations(), zohoSyncReport);
        this.performDeprecationOperations(operations.getDeleteOperations(), zohoSyncReport);
        this.performPermanentDeleteOperations(operations.getPermanentDeleteOperations(), zohoSyncReport);
    }

    void performPermanentDeleteOperations(SortedSet<Operation> permanentDeleteOperations, ZohoSyncReport zohoSyncReport) {
        if (permanentDeleteOperations == null || permanentDeleteOperations.isEmpty()) {
            return;
        }
        List<String> entitiesToDelete = permanentDeleteOperations.stream().map(permDelete -> permDelete.getOrganizationId()).collect(Collectors.toList());
        try {
            this.runPermanentDelete(entitiesToDelete, zohoSyncReport);
        }
        catch (SolrServiceException | RuntimeException e) {
            String message = "Cannot perform permanent delete operations for organizations with ids:" + entitiesToDelete.toArray();
            zohoSyncReport.addFailedOperation(null, "Entity deletion error", message, e);
        }
    }

    void performDeprecationOperations(SortedSet<Operation> deprecateOperations, ZohoSyncReport zohoSyncReport) {
        if (deprecateOperations == null || deprecateOperations.isEmpty()) {
            return;
        }
        for (Operation operation : deprecateOperations) {
            Organization zohoOrganization = ZohoOrganizationConverter.convertToOrganizationEntity((Record)operation.getZohoRecord());
            EntityRecord entityRecord = operation.getEntityRecord();
            this.entityRecordService.addSameReferenceLinks(entityRecord.getEntity(), zohoOrganization.getSameReferenceLinks());
            this.performDeprecation(zohoSyncReport, operation);
        }
    }

    void performDeprecation(ZohoSyncReport zohoSyncReport, Operation operation) {
        try {
            this.entityRecordService.disableEntityRecord(operation.getEntityRecord(), false);
            zohoSyncReport.increaseDeprecated(1L);
        }
        catch (EntityUpdateException e) {
            zohoSyncReport.addFailedOperation(operation.getOrganizationId(), "Solr deletion error", (Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            zohoSyncReport.addFailedOperation(operation.getOrganizationId(), "Entity deprecation error", e);
        }
    }

    void performUpdateOperations(SortedSet<Operation> updateOperations, ZohoSyncReport zohoSyncReport) {
        if (updateOperations == null || updateOperations.isEmpty()) {
            return;
        }
        List<String> organizationIds = updateOperations.stream().map(operation -> operation.getOrganizationId()).collect(Collectors.toList());
        try {
            this.entityUpdateService.scheduleTasks(organizationIds, (ScheduledTaskType)ScheduledUpdateType.FULL_UPDATE);
            zohoSyncReport.increaseUpdated(updateOperations.size());
        }
        catch (RuntimeException e) {
            String message = "Cannot schedule updae operations for organizations with ids:" + organizationIds.toArray();
            zohoSyncReport.addFailedOperation(null, "Entity creation error", message, e);
        }
    }

    private void performCreateOperations(SortedSet<Operation> createOperations, ZohoSyncReport zohoSyncReport) {
        if (createOperations == null || createOperations.isEmpty()) {
            return;
        }
        List<String> entitiesToUpdate = this.performEntityRegistration(createOperations, zohoSyncReport);
        try {
            this.entityUpdateService.scheduleTasks(entitiesToUpdate, (ScheduledTaskType)ScheduledUpdateType.FULL_UPDATE);
            zohoSyncReport.increaseCreated(entitiesToUpdate.size());
        }
        catch (RuntimeException e) {
            String message = "Cannot schedule updae operations for organizations with ids:" + entitiesToUpdate.toArray();
            zohoSyncReport.addFailedOperation(null, "Entity creation error", message, e);
        }
    }

    List<String> performEntityRegistration(SortedSet<Operation> createOperations, ZohoSyncReport zohoSyncReport) {
        ArrayList<String> entitiesToUpdate = new ArrayList<String>(createOperations.size());
        for (Operation operation : createOperations) {
            this.performEntityRegistration(operation, zohoSyncReport, entitiesToUpdate);
        }
        return entitiesToUpdate;
    }

    void performEntityRegistration(Operation operation, ZohoSyncReport zohoSyncReport, List<String> entitiesToUpdate) {
        Organization zohoOrganization = ZohoOrganizationConverter.convertToOrganizationEntity((Record)operation.getZohoRecord());
        ArrayList<String> allCorefs = new ArrayList<String>();
        allCorefs.add(operation.getOrganizationId());
        allCorefs.add(zohoOrganization.getAbout());
        allCorefs.addAll(zohoOrganization.getSameReferenceLinks());
        try {
            Optional<EntityRecord> existingEntity = this.entityRecordService.findEntityDupplicationByCoreference(allCorefs, null);
            if (existingEntity.isPresent()) {
                zohoSyncReport.addFailedOperation(zohoOrganization.getAbout(), "Dupplicate entity error", "Dupplicate of :" + existingEntity.get().getEntityId(), null);
            } else {
                Organization europeanaProxyEntity = new Organization();
                europeanaProxyEntity.setAbout(zohoOrganization.getAbout());
                EntityRecord savedEntityRecord = this.entityRecordService.createEntityFromRequest((Entity)europeanaProxyEntity, (Entity)zohoOrganization, this.getZohoDataSource());
                entitiesToUpdate.add(savedEntityRecord.getEntityId());
                if (logger.isDebugEnabled()) {
                    logger.debug("Created Entity record for externalId={}; entityId={}", (Object)zohoOrganization.getAbout(), (Object)savedEntityRecord.getEntityId());
                }
            }
        }
        catch (EntityCreationException e) {
            zohoSyncReport.addFailedOperation(zohoOrganization.getAbout(), "Entity creation error", "Entity registration failed.", e);
        }
        catch (RuntimeException e) {
            zohoSyncReport.addFailedOperation(zohoOrganization.getAbout(), "Entity creation error", e);
        }
    }

    private void performEnableOperations(SortedSet<Operation> enableOperations, ZohoSyncReport zohoSyncReport) {
        if (enableOperations == null || enableOperations.isEmpty()) {
            return;
        }
        for (Operation operation : enableOperations) {
            try {
                this.entityRecordService.enableEntityRecord(operation.getEntityRecord());
                zohoSyncReport.increaseEnabled(1L);
            }
            catch (EntityUpdateException | RuntimeException e) {
                zohoSyncReport.addFailedOperation(operation.getEntityRecord().getEntityId(), "Entity enable error", (Throwable)e);
            }
        }
    }

    BatchOperations fillOperations(List<Record> orgList) {
        BatchOperations operations = new BatchOperations();
        Set<String> modifiedInZoho = this.getEntityIds(orgList);
        List<EntityRecord> existingRecords = this.findEntityRecordsById(modifiedInZoho);
        for (Record zohoOrg : orgList) {
            String zohoId = zohoOrg.getId().toString();
            Optional<EntityRecord> entityRecordOptional = this.findRecordInList(zohoId, existingRecords);
            EntityRecord entityRecord = null;
            if (entityRecordOptional.isPresent()) {
                entityRecord = entityRecordOptional.get();
            }
            this.addOperation(operations, zohoId, zohoOrg, entityRecord);
        }
        return operations;
    }

    List<EntityRecord> findEntityRecordsById(Set<String> modifiedInZoho) {
        Filter entityIdsFilter = Filters.in((String)"entityId", modifiedInZoho);
        return this.entityRecordRepository.findWithFilters(0, modifiedInZoho.size(), new Filter[]{entityIdsFilter});
    }

    private void addOperation(BatchOperations operations, String zohoId, Record zohoOrg, EntityRecord entityRecord) {
        Operation operation;
        String entityId = EntityRecordUtils.buildEntityIdUri((EntityTypes)EntityTypes.Organization, (String)zohoId);
        boolean hasDpsOwner = this.hasRequiredOwnership(zohoOrg);
        boolean markedForDeletion = ZohoOrganizationConverter.isMarkedForDeletion((Record)zohoOrg);
        String emOperation = null;
        if (entityRecord == null) {
            if (this.skipNonExisting(hasDpsOwner, markedForDeletion)) {
                logger.debug("Organization has changed in zoho, but it is marked for deletion or doesn't have DPS as Owner. Skipped update for Zoho id: {}", (Object)zohoId);
            } else {
                emOperation = "create";
            }
        } else if (!hasDpsOwner || markedForDeletion) {
            emOperation = "delete";
        } else if (this.skipExisting(entityRecord, markedForDeletion)) {
            logger.debug("Organization was marked for deletion, but it is already disabled. Skipped update for Zoho id: {}", (Object)zohoId);
        } else {
            if (this.needsToBeEnabled(entityRecord, hasDpsOwner, markedForDeletion)) {
                operation = new Operation(entityId, "enable", null, entityRecord);
                operations.addOperation(operation);
            }
            emOperation = "update";
        }
        if (emOperation != null) {
            operation = new Operation(entityId, emOperation, zohoOrg, entityRecord);
            operations.addOperation(operation);
        } else if (logger.isInfoEnabled()) {
            logger.info("Organization has changed in zoho, but there is no operation to perform on entity database, probably becasue the zoho organization doesn't have the required role or it was marked for deletion. Zoho id: {}", (Object)zohoId);
        }
    }

    boolean skipNonExisting(boolean hasDpsOwner, boolean markedForDeletion) {
        return markedForDeletion || !hasDpsOwner;
    }

    boolean skipExisting(EntityRecord entityRecord, boolean markedForDeletion) {
        return markedForDeletion && entityRecord.isDisabled();
    }

    boolean needsToBeEnabled(EntityRecord entityRecord, boolean hasDpsOwner, boolean markedForDeletion) {
        return entityRecord != null && entityRecord.isDisabled() && hasDpsOwner && !markedForDeletion;
    }

    boolean hasRequiredOwnership(Record zohoRecord) {
        String ownerName = ZohoOrganizationConverter.getOwnerName((Record)zohoRecord);
        return ownerName.equals(this.emConfiguration.getZohoSyncOwnerFilter());
    }

    Set<String> getEntityIds(List<Record> orgList) {
        HashSet<String> modifiedInZoho = new HashSet<String>();
        if (!orgList.isEmpty()) {
            orgList.forEach(updatedRecord -> modifiedInZoho.add(EntityRecordUtils.buildEntityIdUri((EntityTypes)EntityTypes.Organization, (String)updatedRecord.getId().toString())));
        }
        return modifiedInZoho;
    }

    List<String> getDeletedEntityIds(List<DeletedRecord> deletedInZoho) {
        ArrayList<String> deletedEntityIds = new ArrayList<String>();
        if (!deletedInZoho.isEmpty()) {
            deletedInZoho.forEach(deletedRecord -> deletedEntityIds.add(EntityRecordUtils.buildEntityIdUri((EntityTypes)EntityTypes.Organization, (String)deletedRecord.getId().toString())));
        }
        return deletedEntityIds;
    }

    private Optional<EntityRecord> findRecordInList(String zohoId, List<EntityRecord> existingRecords) {
        if (existingRecords == null || existingRecords.isEmpty()) {
            return Optional.ofNullable(null);
        }
        String identifier = "/" + zohoId;
        return existingRecords.stream().filter(er -> er.getEntityId().endsWith(identifier)).findFirst();
    }

    private void runPermanentDelete(List<String> entitiesDeletedInZoho, ZohoSyncReport zohoSyncReport) throws SolrServiceException {
        long deleted = this.entityRecordService.deleteBulk(entitiesDeletedInZoho, true);
        zohoSyncReport.increaseDeleted(deleted);
    }

    boolean isLastPage(int currentPageSize, int maxItemsPerPage) {
        return currentPageSize < maxItemsPerPage;
    }

    public DataSource getZohoDataSource() {
        return this.zohoDataSource;
    }
}

