/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.europeana.entitymanagement.definitions.batch.model.FailedTask;
import eu.europeana.entitymanagement.definitions.exceptions.EntityManagementRuntimeException;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.vocabulary.FormatTypes;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class SerializationUtils {
    private SerializationUtils() {
    }

    public static String serializeInternalJson(ObjectMapper mapper, EntityRecord record, boolean includeFailure, Optional<FailedTask> failure) throws IOException {
        StringWriter buffer = new StringWriter();
        mapper.writeValue((Writer)buffer, (Object)SerializationUtils.getInternalJsonNode(mapper, record, includeFailure, failure));
        return buffer.toString();
    }

    public static String serializeExternalJson(ObjectMapper mapper, EntityRecord record, boolean includeFailure, Optional<FailedTask> failure) throws IOException {
        StringWriter buffer = new StringWriter();
        mapper.writeValue((Writer)buffer, (Object)SerializationUtils.getExternalJsonNode(mapper, record, includeFailure, failure));
        return buffer.toString();
    }

    public static String serializeExternalJson(ObjectMapper mapper, List<EntityRecord> entityRecords) throws IOException {
        StringWriter buffer = new StringWriter();
        ArrayNode entities = mapper.createArrayNode();
        entityRecords.stream().forEach(entityRecord -> {
            ObjectNode entityNode = SerializationUtils.getExternalJsonNode(mapper, entityRecord, false, null);
            entityNode.remove("@context");
            entities.add((JsonNode)entityNode);
        });
        ObjectNode result = mapper.createObjectNode();
        result.set("@context", mapper.valueToTree((Object)"http://www.europeana.eu/schemas/context/entity.jsonld"));
        result.set("type", mapper.valueToTree((Object)"ResultPage"));
        result.set("total", mapper.valueToTree((Object)entityRecords.size()));
        result.set("items", (JsonNode)entities);
        mapper.writeValue((Writer)buffer, (Object)result);
        return buffer.toString();
    }

    public static void serializeDebugJson(Writer writer, ObjectMapper mapper, EntityRecord record, FormatTypes format, Optional<FailedTask> failedTask) throws IOException {
        JsonNode result = SerializationUtils.getDebugJsonNode(mapper, record, format, failedTask);
        mapper.writeValue(writer, (Object)result);
    }

    private static ObjectNode getExternalJsonNode(ObjectMapper mapper, EntityRecord record, boolean includeFailure, Optional<FailedTask> failure) throws EntityManagementRuntimeException {
        ObjectNode entityNode = (ObjectNode)mapper.valueToTree((Object)record.getEntity());
        if (includeFailure) {
            SerializationUtils.addFailureToEntityNode(mapper, entityNode, failure);
        }
        return entityNode;
    }

    private static void addFailureToEntityNode(ObjectMapper mapper, ObjectNode entityNode, Optional<FailedTask> failedTask) {
        ObjectNode lastFailedEntityTaskNode = failedTask.isPresent() ? (ObjectNode)mapper.valueToTree((Object)failedTask.get()) : mapper.createObjectNode();
        JsonNode isAggregatedByJsonNodeWithFailures = SerializationUtils.combineNestedNode(mapper, (ObjectNode)entityNode.get("isAggregatedBy"), (JsonNode)lastFailedEntityTaskNode, "failures");
        entityNode.set("isAggregatedBy", isAggregatedByJsonNodeWithFailures);
    }

    private static JsonNode getInternalJsonNode(ObjectMapper mapper, EntityRecord record, boolean includeFailure, Optional<FailedTask> failure) {
        ObjectNode entityNode = (ObjectNode)mapper.valueToTree((Object)record.getEntity());
        if (includeFailure) {
            SerializationUtils.addFailureToEntityNode(mapper, entityNode, failure);
        }
        List recordProxies = record.getProxies();
        ArrayNode proxyNode = mapper.createArrayNode();
        for (EntityProxy proxy : recordProxies) {
            ObjectNode proxyEntityNode = null;
            proxyEntityNode = (ObjectNode)mapper.valueToTree((Object)proxy.getEntity());
            proxyEntityNode.remove("@context");
            proxyEntityNode.remove("id");
            ObjectNode embeddedProxyNode = (ObjectNode)mapper.valueToTree((Object)proxy);
            JsonNode mergedNode = SerializationUtils.mergeProxyAndEntity(mapper, embeddedProxyNode, proxyEntityNode);
            proxyNode.add(mergedNode.deepCopy());
        }
        return SerializationUtils.combineNestedNode(mapper, entityNode, (JsonNode)proxyNode, "proxies");
    }

    private static JsonNode getDebugJsonNode(ObjectMapper mapper, EntityRecord record, FormatTypes format, Optional<FailedTask> failedTask) throws JsonMappingException, JsonProcessingException {
        ObjectNode result = mapper.createObjectNode();
        ObjectNode entityNode = (ObjectNode)mapper.valueToTree((Object)record.getEntity());
        ObjectNode lastFailedEntityTaskNode = failedTask.isPresent() ? (ObjectNode)mapper.valueToTree((Object)failedTask.get()) : mapper.createObjectNode();
        JsonNode isAggregatedByJsonNode = entityNode.get("isAggregatedBy");
        JsonNode isAggregatedByJsonNodeWithFailures = SerializationUtils.combineNestedNode(mapper, (ObjectNode)isAggregatedByJsonNode, (JsonNode)lastFailedEntityTaskNode, "failures");
        result.setAll(entityNode);
        result.set("isAggregatedBy", isAggregatedByJsonNodeWithFailures);
        return result;
    }

    private static JsonNode mergeProxyAndEntity(ObjectMapper mapper, ObjectNode proxyNode, ObjectNode entityNode) {
        ObjectNode result = mapper.createObjectNode();
        result.set("id", proxyNode.get("id"));
        result.set("type", proxyNode.get("type"));
        result.setAll(entityNode);
        result.set("proxyFor", proxyNode.get("proxyFor"));
        result.set("proxyIn", proxyNode.get("proxyIn"));
        return result;
    }

    private static JsonNode combineNestedNode(ObjectMapper mapper, ObjectNode parentNode, JsonNode nestedNode, String nestedNodeFieldName) {
        ObjectNode result = mapper.createObjectNode();
        result.setAll(parentNode);
        result.set(nestedNodeFieldName, nestedNode);
        return result;
    }
}

