/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.common.config.LanguageCodes;
import eu.europeana.entitymanagement.normalization.EntityFieldsCleaner;
import eu.europeana.entitymanagement.normalization.EntityFieldsDatatypeValidation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
public class ValidatorConfig {
    private final XmlMapper xmlMapper;
    private final EntityManagementConfiguration emConfiguration;

    @Autowired
    public ValidatorConfig(@Qualifier(value="emXmlMapper") XmlMapper xmlMapper, EntityManagementConfiguration emConfiguration) {
        this.xmlMapper = xmlMapper;
        this.emConfiguration = emConfiguration;
    }

    @Bean(name={"emValidatorFactory"})
    public ValidatorFactory getValidatorFactoryBean() {
        return new LocalValidatorFactoryBean();
    }

    @Bean(name={"emEntityFieldCleaner"})
    public EntityFieldsCleaner getEntityFieldsCleanerBean() throws IOException {
        return new EntityFieldsCleaner(this.getLanguageCodes(), this.emConfiguration.getThumbnailBaseUrl());
    }

    @Bean(name={"emEntityFieldDatatypeValidation"})
    public EntityFieldsDatatypeValidation getEntityFieldsDatatypeValidationBean() throws IOException {
        return new EntityFieldsDatatypeValidation(this.getLanguageCodes());
    }

    @Bean(name={"emLanguageCodes"})
    public LanguageCodes getLanguageCodes() throws IOException {
        String languagecodesXMLConfig = this.emConfiguration.getLanguagecodesXMLConfig();
        try (InputStream inputStream = this.getClass().getResourceAsStream(languagecodesXMLConfig);){
            LanguageCodes languageCodes;
            assert (inputStream != null);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String contents = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                languageCodes = (LanguageCodes)this.xmlMapper.readValue(contents, LanguageCodes.class);
            }
            return languageCodes;
        }
    }
}

