/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.writer;

import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.solr.SolrUtils;
import eu.europeana.entitymanagement.solr.service.SolrService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
public class EntitySolrInsertionWriter
implements ItemWriter<EntityRecord> {
    private final SolrService solrService;

    public EntitySolrInsertionWriter(SolrService solrService) {
        this.solrService = solrService;
    }

    public void write(List<? extends EntityRecord> entityRecords) throws Exception {
        List solrEntities = entityRecords.stream().map(entityRecord -> SolrUtils.createSolrEntity((EntityRecord)entityRecord)).collect(Collectors.toList());
        this.solrService.storeMultipleEntities(solrEntities);
    }
}

