/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.writer;

import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class EntityRecordDatabaseRemovalWriter
implements ItemWriter<EntityRecord> {
    private final EntityRecordService entityRecordService;

    public EntityRecordDatabaseRemovalWriter(EntityRecordService entityRecordService) {
        this.entityRecordService = entityRecordService;
    }

    public void write(@NonNull List<? extends EntityRecord> entityRecords) throws Exception {
        List<String> ids = List.of(BatchUtils.getEntityIds(entityRecords));
        this.entityRecordService.deleteBulk(ids, false);
    }
}

