/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.service;

import com.mongodb.client.result.UpdateResult;
import dev.morphia.query.experimental.filters.Filter;
import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.exceptions.EntityCreationException;
import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.definitions.web.EntityIdDisabledStatus;
import eu.europeana.entitymanagement.exception.EntityAlreadyExistsException;
import eu.europeana.entitymanagement.exception.EntityNotFoundException;
import eu.europeana.entitymanagement.exception.EntityRemovedException;
import eu.europeana.entitymanagement.exception.HttpBadRequestException;
import eu.europeana.entitymanagement.exception.HttpUnprocessableException;
import eu.europeana.entitymanagement.exception.ingestion.EntityUpdateException;
import eu.europeana.entitymanagement.mongo.repository.EntityRecordRepository;
import eu.europeana.entitymanagement.solr.SolrUtils;
import eu.europeana.entitymanagement.solr.exception.SolrServiceException;
import eu.europeana.entitymanagement.solr.service.SolrService;
import eu.europeana.entitymanagement.utils.EntityObjectFactory;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.utils.UriValidator;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import eu.europeana.entitymanagement.zoho.utils.WikidataUtils;
import eu.europeana.entitymanagement.zoho.utils.ZohoUtils;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="emEntityRecordService")
public class EntityRecordService {
    private final EntityRecordRepository entityRecordRepository;
    final EntityManagementConfiguration emConfiguration;
    private final DataSources datasources;
    private final SolrService solrService;
    private static final Logger logger = LogManager.getLogger(EntityRecordService.class);
    private static final String ENTITY_ID_REMOVED_MSG = "Entity '%s' has been removed";
    private static final List<String> ignoredMergeFields = List.of("type");

    @Autowired
    public EntityRecordService(EntityRecordRepository entityRecordRepository, EntityManagementConfiguration emConfiguration, DataSources datasources, SolrService solrService) {
        this.entityRecordRepository = entityRecordRepository;
        this.emConfiguration = emConfiguration;
        this.datasources = datasources;
        this.solrService = solrService;
    }

    public boolean existsByEntityId(String entityId) {
        return this.entityRecordRepository.existsByEntityId(entityId);
    }

    public Optional<EntityRecord> retrieveByEntityId(String entityId) {
        return Optional.ofNullable(this.entityRecordRepository.findByEntityId(entityId));
    }

    public List<EntityRecord> retrieveMultipleByEntityIds(List<String> entityIds) {
        return this.entityRecordRepository.findByEntityIds(entityIds, true, true);
    }

    public EntityRecord retrieveEntityRecord(String type, String identifier, boolean retrieveDisabled) throws EuropeanaApiException {
        String entityUri = EntityRecordUtils.buildEntityIdUri((String)type, (String)identifier);
        Optional entityRecordOptional = this.retrieveByEntityId(entityUri);
        if (entityRecordOptional.isEmpty()) {
            throw new EntityNotFoundException(entityUri);
        }
        EntityRecord entityRecord = (EntityRecord)entityRecordOptional.get();
        if (!retrieveDisabled && entityRecord.isDisabled()) {
            throw new EntityRemovedException(String.format(ENTITY_ID_REMOVED_MSG, entityUri));
        }
        return entityRecord;
    }

    public List<EntityIdDisabledStatus> retrieveMultipleByEntityId(List<String> entityIds, boolean excludeDisabled) {
        return this.entityRecordRepository.getEntityIds(entityIds, excludeDisabled);
    }

    public Optional<EntityRecord> findEntityDupplicationByCoreference(List<String> uris, String entityId) {
        return this.entityRecordRepository.findEntityDupplicationByCoreference(uris, entityId);
    }

    public EntityRecord saveEntityRecord(EntityRecord er) {
        return this.entityRecordRepository.save(er);
    }

    public List<? extends EntityRecord> saveBulkEntityRecords(List<? extends EntityRecord> records) {
        return this.entityRecordRepository.saveBulk(records);
    }

    public long deleteBulk(List<String> entityIds, boolean deleteFromSolr) throws SolrServiceException {
        long deleteCount;
        if (deleteFromSolr) {
            this.solrService.deleteById(entityIds, true);
        }
        if ((deleteCount = this.entityRecordRepository.deleteBulk(entityIds)) > 0L) {
            logger.info("Deleted {} entityRecords from database: entityIds={}", (Object)deleteCount, entityIds);
        }
        return deleteCount;
    }

    @Deprecated
    public void disableBulk(List<? extends EntityRecord> entityRecords) {
        String[] entityIds = BatchUtils.getEntityIds(entityRecords);
        UpdateResult updateResult = this.entityRecordRepository.disableBulk(List.of(entityIds));
        logger.info("Deprecated {} entities: entityIds={}", (Object)updateResult.getModifiedCount(), (Object)entityIds);
    }

    public void disableEntityRecord(EntityRecord er, boolean forceSolrCommit) throws EntityUpdateException {
        try {
            this.solrService.deleteById(List.of(er.getEntityId()), forceSolrCommit);
        }
        catch (SolrServiceException e) {
            throw new EntityUpdateException("Cannot delete solr record with id: " + er.getEntityId(), (Throwable)e);
        }
        er.setDisabled(new Date());
        this.saveEntityRecord(er);
    }

    public void enableEntityRecord(EntityRecord entityRecord) throws EntityUpdateException {
        entityRecord.setDisabled(null);
        this.saveEntityRecord(entityRecord);
        try {
            this.solrService.storeEntity(SolrUtils.createSolrEntity((EntityRecord)entityRecord));
        }
        catch (SolrServiceException e) {
            throw new EntityUpdateException("Cannot create solr record for entity with id: " + entityRecord.getEntityId(), (Throwable)e);
        }
    }

    public EntityRecord update(EntityRecord entityRecord) {
        return this.saveEntityRecord(entityRecord);
    }

    public long delete(String entityId) throws SolrServiceException {
        this.solrService.deleteById(List.of(entityId), true);
        return this.entityRecordRepository.deleteForGood(entityId);
    }

    public EntityRecord createEntityFromMigrationRequest(Entity europeanaProxyEntity, String type, String identifier) throws EntityCreationException, EntityAlreadyExistsException, HttpBadRequestException, HttpUnprocessableException {
        String externalProxyId = europeanaProxyEntity.getEntityId();
        DataSource externalDatasource = this.datasources.verifyDataSource(externalProxyId, true);
        Date timestamp = new Date();
        Entity entity = EntityObjectFactory.createConsolidatedEntityObject((String)type);
        String entityId = this.generateEntityId(entity.getType(), identifier);
        this.checkIfEntityAlreadyExists(entityId);
        entity.setEntityId(entityId);
        entity.setSameReferenceLinks(new ArrayList<String>(List.of(externalProxyId)));
        EntityRecord entityRecord = new EntityRecord();
        entityRecord.setEntityId(entityId);
        entityRecord.setEntity(entity);
        europeanaProxyEntity.setEntityId(entityId);
        this.setEuropeanaMetadata(europeanaProxyEntity, entityId, entityRecord, timestamp);
        Entity metisEntity = EntityObjectFactory.createProxyEntityObject((String)type);
        this.setExternalProxy(metisEntity, externalProxyId, entityId, externalDatasource, entityRecord, timestamp, 1);
        this.upsertEntityAggregation(entityRecord, entityId, timestamp);
        return this.entityRecordRepository.save(entityRecord);
    }

    public EntityRecord createEntityFromRequest(Entity europeanaProxyEntity, Entity datasourceResponse, DataSource dataSource) throws EntityCreationException {
        Optional wikidataId;
        String externalProxyId = europeanaProxyEntity.getEntityId();
        Date timestamp = new Date();
        Entity entity = EntityObjectFactory.createConsolidatedEntityObject((Entity)europeanaProxyEntity);
        boolean isZohoOrg = ZohoUtils.isZohoOrganization((String)externalProxyId, (String)datasourceResponse.getType());
        String entityId = this.generateEntityId(datasourceResponse, isZohoOrg);
        EntityRecord entityRecord = new EntityRecord();
        entityRecord.setEntityId(entityId);
        entity.setEntityId(entityId);
        List sameAs = this.buildSameAsReferenceLinks(externalProxyId, datasourceResponse, europeanaProxyEntity);
        entity.setSameReferenceLinks(sameAs);
        entityRecord.setEntity(entity);
        europeanaProxyEntity.setEntityId(entityId);
        this.setEuropeanaMetadata(europeanaProxyEntity, entityId, entityRecord, timestamp);
        this.setExternalProxy(datasourceResponse, externalProxyId, entityId, dataSource, entityRecord, timestamp, 1);
        this.upsertEntityAggregation(entityRecord, entityId, timestamp);
        if (isZohoOrg && (wikidataId = WikidataUtils.getWikidataId((List)datasourceResponse.getSameReferenceLinks())).isPresent()) {
            String wikidataProxyId = (String)wikidataId.get();
            this.appendWikidataProxy(entityRecord, wikidataProxyId, datasourceResponse.getType(), timestamp);
        }
        return this.entityRecordRepository.save(entityRecord);
    }

    public EntityProxy appendWikidataProxy(EntityRecord entityRecord, String wikidataProxyId, String entityType, Date timestamp) throws EntityCreationException {
        Entity wikidataProxyEntity = EntityObjectFactory.createProxyEntityObject((String)entityType);
        Optional wikidataDatasource = this.getDataSource(wikidataProxyId);
        int proxyNr = entityRecord.getProxies().size();
        EntityProxy wikidataProxy = this.setExternalProxy(wikidataProxyEntity, wikidataProxyId, entityRecord.getEntityId(), (DataSource)wikidataDatasource.get(), entityRecord, timestamp, proxyNr);
        entityRecord.getEntity().addSameReferenceLink(wikidataProxyId);
        Aggregation isAggregatedBy = entityRecord.getEntity().getIsAggregatedBy();
        this.updateEntityAggregatesList(isAggregatedBy, entityRecord, entityRecord.getEntityId());
        return wikidataProxy;
    }

    String generateEntityId(Entity datasourceResponse, boolean isZohoOrg) {
        String entityId = null;
        if (isZohoOrg) {
            String zohoId = EntityRecordUtils.getIdFromUrl((String)datasourceResponse.getEntityId());
            entityId = EntityRecordUtils.buildEntityIdUri((String)datasourceResponse.getType(), (String)zohoId);
        } else {
            entityId = this.generateEntityId(datasourceResponse.getType(), null);
        }
        return entityId;
    }

    List<String> buildSameAsReferenceLinks(String externalProxyId, Entity datasourceResponse, Entity europeanaProxyEntity) {
        TreeSet<String> sameAsUrls = new TreeSet<String>();
        sameAsUrls.add(datasourceResponse.getEntityId());
        sameAsUrls.add(externalProxyId);
        if (datasourceResponse.getSameReferenceLinks() != null) {
            sameAsUrls.addAll(datasourceResponse.getSameReferenceLinks());
        }
        if (europeanaProxyEntity.getSameReferenceLinks() != null) {
            sameAsUrls.addAll(europeanaProxyEntity.getSameReferenceLinks());
        }
        ArrayList<String> sameAs = new ArrayList<String>(sameAsUrls);
        return sameAs;
    }

    private Optional<DataSource> getDataSource(String externalProxyId) throws EntityCreationException {
        Optional externalDatasourceOptional = this.datasources.getDatasource(externalProxyId);
        if (externalDatasourceOptional.isEmpty()) {
            throw new EntityCreationException("No configured datasource for id " + externalProxyId);
        }
        return externalDatasourceOptional;
    }

    private void checkIfEntityAlreadyExists(String entityId) throws EntityAlreadyExistsException {
        Optional entityRecordOptional = this.retrieveByEntityId(entityId);
        if (entityRecordOptional.isPresent()) {
            throw new EntityAlreadyExistsException(entityId);
        }
    }

    private String generateEntityId(String entityType, String entityId) {
        if (entityId != null) {
            return EntityRecordUtils.buildEntityIdUri((String)entityType, (String)entityId);
        }
        long dbId = this.entityRecordRepository.generateAutoIncrement(entityType);
        return EntityRecordUtils.buildEntityIdUri((String)entityType, (String)String.valueOf(dbId));
    }

    public void performReferentialIntegrity(Entity entity) {
        this.performCommonReferentialIntegrity(entity);
        switch (1.$SwitchMap$eu$europeana$entitymanagement$vocabulary$EntityTypes[EntityTypes.valueOf((String)entity.getType()).ordinal()]) {
            case 1: {
                this.performReferentialIntegrityConcept((Concept)entity);
                break;
            }
            case 2: {
                this.performReferentialIntegrityAgent((Agent)entity);
                break;
            }
            case 3: {
                this.performReferentialIntegrityPlace((Place)entity);
                break;
            }
            case 4: {
                this.performReferentialIntegrityTimespan((TimeSpan)entity);
                break;
            }
            case 5: {
                break;
            }
        }
    }

    private void performCommonReferentialIntegrity(Entity entity) {
        List hasPartField = entity.getHasPart();
        entity.setHasPart(this.replaceWithInternalReferences(hasPartField));
        List isPartOfField = entity.getIsPartOfArray();
        entity.setIsPartOfArray(this.replaceWithInternalReferences(isPartOfField));
        List isRelatedToField = entity.getIsRelatedTo();
        entity.setIsRelatedTo(this.replaceWithInternalReferences(isRelatedToField));
    }

    private void performReferentialIntegrityConcept(Concept entity) {
        List broaderField = entity.getBroader();
        entity.setBroader(this.replaceWithInternalReferences(broaderField));
        List narrowerField = entity.getNarrower();
        entity.setNarrower(this.replaceWithInternalReferences(narrowerField));
        List relatedField = entity.getRelated();
        entity.setRelated(this.replaceWithInternalReferences(relatedField));
    }

    private void performReferentialIntegrityAgent(Agent entity) {
        List placeOfBirthField = entity.getPlaceOfBirth();
        entity.setPlaceOfBirth(this.replaceWithInternalReferences(placeOfBirthField));
        List placeOfDeathField = entity.getPlaceOfDeath();
        entity.setPlaceOfDeath(this.replaceWithInternalReferences(placeOfDeathField));
        List professionOrOccupationField = entity.getProfessionOrOccupation();
        entity.setProfessionOrOccupation(this.replaceWithInternalReferences(professionOrOccupationField));
        List hasMetField = entity.getHasMet();
        entity.setHasMet(this.replaceWithInternalReferences(hasMetField));
        List wasPresentField = entity.getWasPresentAt();
        entity.setWasPresentAt(this.replaceWithInternalReferences(wasPresentField));
        List dateField = entity.getDate();
        entity.setDate(this.replaceWithInternalReferences(dateField));
    }

    private void performReferentialIntegrityPlace(Place entity) {
        List isNextInSequenceField = entity.getIsNextInSequence();
        entity.setIsNextInSequence(this.replaceWithInternalReferences(isNextInSequenceField));
    }

    private void performReferentialIntegrityTimespan(TimeSpan entity) {
        List isNextInSequenceField = entity.getIsNextInSequence();
        entity.setIsNextInSequence(this.replaceWithInternalReferences(isNextInSequenceField));
    }

    @Deprecated(since="", forRemoval=false)
    private Map<String, List<String>> replaceWithInternalReferences(Map<String, List<String>> originalReferences) {
        if (originalReferences == null) {
            return null;
        }
        HashMap<String, List<String>> updatedReferenceMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : originalReferences.entrySet()) {
            ArrayList updatedReferences = new ArrayList();
            for (String value : entry.getValue()) {
                this.addValueOrInternalReference(updatedReferences, value);
            }
            if (updatedReferences.isEmpty()) continue;
            updatedReferenceMap.put(entry.getKey(), updatedReferences);
        }
        if (updatedReferenceMap.isEmpty()) {
            return null;
        }
        return updatedReferenceMap;
    }

    private List<String> replaceWithInternalReferences(List<String> originalReferences) {
        if (originalReferences == null) {
            return null;
        }
        ArrayList<String> updatedReferences = new ArrayList<String>();
        for (String entry : originalReferences) {
            this.addValueOrInternalReference(updatedReferences, entry);
        }
        if (updatedReferences.isEmpty()) {
            return null;
        }
        return updatedReferences;
    }

    private void addValueOrInternalReference(List<String> updatedReferences, String value) {
        if (value.startsWith("http://data.europeana.eu/") || !UriValidator.isUri((String)value)) {
            updatedReferences.add(value);
        } else {
            Optional record = this.findEntityDupplicationByCoreference(Collections.singletonList(value), null);
            record.ifPresent(entityRecord -> updatedReferences.add(entityRecord.getEntityId()));
        }
    }

    public Entity mergeEntities(Entity primary, Entity secondary) throws EuropeanaApiException {
        List fieldsToCombine = EntityUtils.getAllFields(primary.getClass()).stream().filter(f -> !ignoredMergeFields.contains(f.getName())).collect(Collectors.toList());
        return this.combineEntities(primary, secondary, fieldsToCombine, true);
    }

    public void updateConsolidatedVersion(EntityRecord entityRecord, Entity consolidatedEntity) {
        entityRecord.setEntity(consolidatedEntity);
        this.upsertEntityAggregation(entityRecord, consolidatedEntity.getEntityId(), new Date());
    }

    public void replaceEuropeanaProxy(Entity updateRequestEntity, EntityRecord entityRecord) {
        EntityProxy europeanaProxy = entityRecord.getEuropeanaProxy();
        String entityId = europeanaProxy.getEntity().getEntityId();
        europeanaProxy.setEntity(updateRequestEntity);
        europeanaProxy.getEntity().setEntityId(entityId);
        europeanaProxy.getProxyIn().setModified(Date.from(Instant.now()));
    }

    private Entity combineEntities(Entity primary, Entity secondary, List<Field> fieldsToCombine, boolean accumulate) throws EuropeanaApiException {
        Entity consolidatedEntity = EntityObjectFactory.createConsolidatedEntityObject((String)primary.getType());
        try {
            HashMap prefLabelsForAltLabels = new HashMap();
            for (Field field : fieldsToCombine) {
                Class<?> fieldType = field.getType();
                String fieldName = field.getName();
                if (fieldType.isArray()) {
                    Object[] mergedArray = this.mergeArrays(primary, secondary, field, accumulate);
                    consolidatedEntity.setFieldValue(field, (Object)mergedArray);
                    continue;
                }
                if (List.class.isAssignableFrom(fieldType)) {
                    List fieldValuePrimaryObjectList = (List)primary.getFieldValue(field);
                    List fieldValueSecondaryObjectList = (List)secondary.getFieldValue(field);
                    this.mergeList(consolidatedEntity, fieldValuePrimaryObjectList, fieldValueSecondaryObjectList, field, accumulate);
                    continue;
                }
                if (this.isStringOrPrimitive(fieldType)) {
                    Object fieldValuePrimaryObjectPrimitiveOrString = primary.getFieldValue(field);
                    Object fieldValueSecondaryObjectPrimitiveOrString = secondary.getFieldValue(field);
                    if (fieldValuePrimaryObjectPrimitiveOrString == null && fieldValueSecondaryObjectPrimitiveOrString != null) {
                        consolidatedEntity.setFieldValue(field, fieldValueSecondaryObjectPrimitiveOrString);
                        continue;
                    }
                    if (fieldValuePrimaryObjectPrimitiveOrString == null) continue;
                    consolidatedEntity.setFieldValue(field, fieldValuePrimaryObjectPrimitiveOrString);
                    continue;
                }
                if (Date.class.isAssignableFrom(fieldType)) {
                    Object fieldValuePrimaryObjectDate = primary.getFieldValue(field);
                    Object fieldValueSecondaryObjectDate = secondary.getFieldValue(field);
                    if (fieldValuePrimaryObjectDate == null && fieldValueSecondaryObjectDate != null) {
                        consolidatedEntity.setFieldValue(field, (Object)new Date(((Date)fieldValueSecondaryObjectDate).getTime()));
                        continue;
                    }
                    if (fieldValuePrimaryObjectDate == null) continue;
                    consolidatedEntity.setFieldValue(field, (Object)new Date(((Date)fieldValuePrimaryObjectDate).getTime()));
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    this.combineEntities(consolidatedEntity, primary, secondary, prefLabelsForAltLabels, field, fieldName, accumulate);
                    continue;
                }
                if (WebResource.class.isAssignableFrom(fieldType)) {
                    this.mergeWebResources(primary, secondary, field, consolidatedEntity);
                    continue;
                }
                if (!Address.class.isAssignableFrom(fieldType)) continue;
                this.mergeAddress(primary, secondary, field, consolidatedEntity);
            }
            this.mergeSkippedPrefLabels(consolidatedEntity, prefLabelsForAltLabels, fieldsToCombine);
        }
        catch (IllegalAccessException e) {
            throw new EntityUpdateException("Metadata consolidation failed to access required properties!", (Throwable)e);
        }
        return consolidatedEntity;
    }

    private void mergeWebResources(Entity primary, Entity secondary, Field field, Entity consolidatedEntity) throws IllegalAccessException {
        WebResource primaryWebResource = (WebResource)primary.getFieldValue(field);
        WebResource secondaryWebResource = (WebResource)secondary.getFieldValue(field);
        if (primaryWebResource == null && secondaryWebResource != null) {
            consolidatedEntity.setFieldValue(field, (Object)new WebResource(secondaryWebResource));
        } else if (primaryWebResource != null) {
            consolidatedEntity.setFieldValue(field, (Object)new WebResource(primaryWebResource));
        }
    }

    private void mergeAddress(Entity primary, Entity secondary, Field field, Entity consolidatedEntity) throws IllegalAccessException {
        Address primaryAddress = (Address)primary.getFieldValue(field);
        Address secondaryAddress = (Address)secondary.getFieldValue(field);
        if (primaryAddress == null && secondaryAddress != null) {
            consolidatedEntity.setFieldValue(field, (Object)new Address(secondaryAddress));
        } else if (primaryAddress != null) {
            consolidatedEntity.setFieldValue(field, (Object)new Address(primaryAddress));
        }
    }

    boolean isStringOrPrimitive(Class<?> fieldType) {
        return String.class.isAssignableFrom(fieldType) || fieldType.isPrimitive() || Float.class.isAssignableFrom(fieldType) || Integer.class.isAssignableFrom(fieldType);
    }

    void combineEntities(Entity consolidatedEntity, Entity primary, Entity secondary, Map<Object, Object> prefLabelsForAltLabels, Field field, String fieldName, boolean accumulate) throws IllegalAccessException {
        Map fieldValuePrimaryObjectMap = (Map)primary.getFieldValue(field);
        Map fieldValueSecondaryObjectMap = (Map)secondary.getFieldValue(field);
        Map fieldValuePrimaryObject = this.initialiseObjectMap(fieldValuePrimaryObjectMap);
        Map fieldValueSecondaryObject = this.initialiseObjectMap(fieldValueSecondaryObjectMap);
        if (CollectionUtils.isEmpty((Map)fieldValuePrimaryObject) && !CollectionUtils.isEmpty((Map)fieldValueSecondaryObject)) {
            fieldValuePrimaryObject.putAll(fieldValueSecondaryObject);
        } else if (!CollectionUtils.isEmpty((Map)fieldValuePrimaryObject) && !CollectionUtils.isEmpty((Map)fieldValueSecondaryObject) && accumulate) {
            for (Map.Entry elemSecondary : fieldValueSecondaryObject.entrySet()) {
                Object key = elemSecondary.getKey();
                this.mergePrimarySecondaryListWitoutDuplicates(fieldValuePrimaryObject, key, elemSecondary, fieldName, prefLabelsForAltLabels);
            }
        }
        if (!CollectionUtils.isEmpty((Map)fieldValuePrimaryObject)) {
            consolidatedEntity.setFieldValue(field, (Object)fieldValuePrimaryObject);
        }
    }

    private void mergePrimarySecondaryListWitoutDuplicates(Map<Object, Object> fieldValuePrimaryObject, Object key, Map.Entry elemSecondary, String fieldName, Map<Object, Object> prefLabelsForAltLabels) {
        if (fieldValuePrimaryObject.containsKey(key) && List.class.isAssignableFrom(elemSecondary.getValue().getClass())) {
            List listSecondaryObject = (List)elemSecondary.getValue();
            ArrayList listPrimaryObject = new ArrayList((List)fieldValuePrimaryObject.get(key));
            boolean listPrimaryObjectChanged = false;
            for (Object elemSecondaryList : listSecondaryObject) {
                if (listPrimaryObject.contains(elemSecondaryList)) continue;
                listPrimaryObject.add(elemSecondaryList);
                if (listPrimaryObjectChanged) continue;
                listPrimaryObjectChanged = true;
            }
            if (listPrimaryObjectChanged) {
                fieldValuePrimaryObject.put(key, listPrimaryObject);
            }
        } else if (fieldValuePrimaryObject.containsKey(key) && fieldName.toLowerCase().contains("pref") && fieldName.toLowerCase().contains("label")) {
            Object primaryObjectPrefLabel = fieldValuePrimaryObject.get(key);
            if (!primaryObjectPrefLabel.equals(elemSecondary.getValue())) {
                prefLabelsForAltLabels.put(key, elemSecondary.getValue());
            }
        } else if (!fieldValuePrimaryObject.containsKey(key)) {
            fieldValuePrimaryObject.put(key, elemSecondary.getValue());
        }
    }

    private Map<Object, Object> initialiseObjectMap(Map<Object, Object> fieldValueObjectMap) {
        if (fieldValueObjectMap != null) {
            return new HashMap<Object, Object>(fieldValueObjectMap);
        }
        return new HashMap<Object, Object>();
    }

    void mergeSkippedPrefLabels(Entity consilidatedEntity, Map<Object, Object> prefLabelsForAltLabels, List<Field> allEntityFields) throws IllegalAccessException {
        if (prefLabelsForAltLabels.size() > 0) {
            for (Field field : allEntityFields) {
                String fieldName = field.getName();
                if (!this.isFieldAltLabel(fieldName)) continue;
                Map altLabelConsolidatedMap = (Map)consilidatedEntity.getFieldValue(field);
                Map altLabelPrimaryObject = this.initialiseAltLabelMap(altLabelConsolidatedMap);
                boolean altLabelPrimaryValueChanged = false;
                if (!(altLabelPrimaryValueChanged = this.addValuesToAltLabel(prefLabelsForAltLabels, altLabelPrimaryObject, altLabelPrimaryValueChanged))) break;
                consilidatedEntity.setFieldValue(field, (Object)altLabelPrimaryObject);
                break;
            }
        }
    }

    private boolean addValuesToAltLabel(Map<Object, Object> prefLabelsForAltLabels, Map<Object, Object> altLabelPrimaryObject, boolean altLabelPrimaryValueChanged) {
        for (Map.Entry<Object, Object> prefLabel : prefLabelsForAltLabels.entrySet()) {
            String keyPrefLabel = (String)prefLabel.getKey();
            List altLabelPrimaryObjectList = (List)altLabelPrimaryObject.get(keyPrefLabel);
            List altLabelPrimaryValue = this.initialiseAltLabelList(altLabelPrimaryObjectList);
            if (!this.shouldValuesBeAddedToAltLabel(altLabelPrimaryValue, prefLabel)) continue;
            altLabelPrimaryValue.add(prefLabel.getValue());
            if (!altLabelPrimaryValueChanged) {
                altLabelPrimaryValueChanged = true;
            }
            altLabelPrimaryObject.put(keyPrefLabel, altLabelPrimaryValue);
        }
        return altLabelPrimaryValueChanged;
    }

    private boolean isFieldAltLabel(String fieldName) {
        return fieldName.toLowerCase().contains("alt") && fieldName.toLowerCase().contains("label");
    }

    private boolean shouldValuesBeAddedToAltLabel(List<Object> altLabelPrimaryValue, Map.Entry<Object, Object> prefLabel) {
        return altLabelPrimaryValue.isEmpty() || !altLabelPrimaryValue.isEmpty() && !altLabelPrimaryValue.contains(prefLabel.getValue());
    }

    private Map<Object, Object> initialiseAltLabelMap(Map<Object, Object> altLabelConsolidatedMap) {
        if (altLabelConsolidatedMap != null) {
            return new HashMap<Object, Object>(altLabelConsolidatedMap);
        }
        return new HashMap<Object, Object>();
    }

    private List<Object> initialiseAltLabelList(List<Object> altLabelPrimaryObjectList) {
        if (altLabelPrimaryObjectList != null) {
            return new ArrayList<Object>(altLabelPrimaryObjectList);
        }
        return new ArrayList<Object>();
    }

    void mergeList(Entity consolidatedEntity, List<Object> fieldValuePrimaryObjectList, List<Object> fieldValueSecondaryObjectList, Field field, boolean accumulate) throws IllegalAccessException {
        ArrayList<Object> fieldValuePrimaryObject = null;
        ArrayList<Object> fieldValueSecondaryObject = null;
        if (fieldValuePrimaryObjectList != null) {
            fieldValuePrimaryObject = new ArrayList<Object>(fieldValuePrimaryObjectList);
        }
        if (fieldValueSecondaryObjectList != null) {
            fieldValueSecondaryObject = new ArrayList<Object>(fieldValueSecondaryObjectList);
        }
        if (fieldValuePrimaryObject != null && fieldValueSecondaryObject != null) {
            if (accumulate) {
                for (Object e : fieldValueSecondaryObject) {
                    if (fieldValuePrimaryObject.contains(e)) continue;
                    fieldValuePrimaryObject.add(e);
                }
                consolidatedEntity.setFieldValue(field, fieldValuePrimaryObject);
            } else {
                consolidatedEntity.setFieldValue(field, fieldValuePrimaryObject);
            }
            return;
        }
        if (fieldValuePrimaryObject == null && fieldValueSecondaryObject != null) {
            consolidatedEntity.setFieldValue(field, fieldValueSecondaryObject);
            return;
        }
        if (fieldValuePrimaryObject != null && fieldValueSecondaryObject == null) {
            consolidatedEntity.setFieldValue(field, fieldValuePrimaryObject);
            return;
        }
    }

    Object[] mergeArrays(Entity primary, Entity secondary, Field field, boolean append) throws IllegalAccessException {
        Object[] primaryArray = (Object[])primary.getFieldValue(field);
        Object[] secondaryArray = (Object[])secondary.getFieldValue(field);
        if (primaryArray == null && secondaryArray == null) {
            return null;
        }
        if (primaryArray == null) {
            return (Object[])secondaryArray.clone();
        }
        if (secondaryArray == null || !append) {
            return (Object[])primaryArray.clone();
        }
        TreeSet<Object> mergedAndOrdered = new TreeSet<Object>(Arrays.asList(primaryArray));
        mergedAndOrdered.addAll(Arrays.asList(secondaryArray));
        return mergedAndOrdered.toArray(Arrays.copyOf(primaryArray, 0));
    }

    public void dropRepository() {
        this.entityRecordRepository.dropCollection();
    }

    @Deprecated
    public List<? extends EntityRecord> findEntitiesWithFilter(int start, int count, Filter[] queryFilters) {
        return this.entityRecordRepository.findWithFilters(start, count, queryFilters);
    }

    private void upsertEntityAggregation(EntityRecord entityRecord, String entityId, Date timestamp) {
        Aggregation aggregation = entityRecord.getEntity().getIsAggregatedBy();
        if (aggregation == null) {
            aggregation = this.createNewAggregation(entityId, timestamp);
            entityRecord.getEntity().setIsAggregatedBy(aggregation);
        } else {
            aggregation.setModified(timestamp);
        }
        this.updateEntityAggregatesList(aggregation, entityRecord, entityId);
    }

    private Aggregation createNewAggregation(String entityId, Date timestamp) {
        Aggregation isAggregatedBy = new Aggregation();
        isAggregatedBy.setId(EntityRecordUtils.getIsAggregatedById((String)entityId));
        isAggregatedBy.setCreated(timestamp);
        isAggregatedBy.setModified(timestamp);
        return isAggregatedBy;
    }

    private void updateEntityAggregatesList(Aggregation aggregation, EntityRecord entityRecord, String entityId) {
        ArrayList<String> aggregates = new ArrayList<String>();
        aggregates.add(EntityRecordUtils.getEuropeanaAggregationId((String)entityId));
        if (entityRecord.getExternalProxies() != null) {
            for (int i = 0; i < entityRecord.getExternalProxies().size(); ++i) {
                aggregates.add(EntityRecordUtils.getDatasourceAggregationId((String)entityRecord.getEntityId(), (int)(i + 1)));
            }
        }
        aggregation.setAggregates(aggregates);
    }

    private void setEuropeanaMetadata(Entity europeanaProxyMetadata, String entityId, EntityRecord entityRecord, Date timestamp) {
        Aggregation europeanaAggr = new Aggregation();
        Optional europeanaDataSource = this.datasources.getEuropeanaDatasource();
        europeanaAggr.setId(EntityRecordUtils.getEuropeanaAggregationId((String)entityId));
        europeanaAggr.setRights(((DataSource)europeanaDataSource.get()).getRights());
        europeanaAggr.setSource(((DataSource)europeanaDataSource.get()).getUrl());
        europeanaAggr.setCreated(timestamp);
        europeanaAggr.setModified(timestamp);
        EntityProxy europeanaProxy = new EntityProxy();
        europeanaProxy.setProxyId(EntityRecordUtils.getEuropeanaProxyId((String)entityId));
        europeanaProxy.setProxyFor(entityId);
        europeanaProxy.setProxyIn(europeanaAggr);
        europeanaProxy.setEntity(europeanaProxyMetadata);
        entityRecord.addProxy(europeanaProxy);
    }

    private EntityProxy setExternalProxy(Entity metisResponse, String proxyId, String entityId, DataSource externalDatasource, EntityRecord entityRecord, Date timestamp, int aggregationId) {
        Aggregation datasourceAggr = new Aggregation();
        datasourceAggr.setId(EntityRecordUtils.getDatasourceAggregationId((String)entityId, (int)aggregationId));
        datasourceAggr.setCreated(timestamp);
        datasourceAggr.setModified(timestamp);
        datasourceAggr.setRights(externalDatasource.getRights());
        datasourceAggr.setSource(externalDatasource.getUrl());
        EntityProxy datasourceProxy = new EntityProxy();
        datasourceProxy.setProxyId(proxyId);
        datasourceProxy.setProxyFor(entityId);
        datasourceProxy.setProxyIn(datasourceAggr);
        datasourceProxy.setEntity(metisResponse);
        entityRecord.addProxy(datasourceProxy);
        return datasourceProxy;
    }

    public void changeExternalProxy(EntityRecord entityRecord, String newProxyId) throws EuropeanaApiException {
        DataSource dataSource = this.datasources.verifyDataSource(newProxyId, true);
        List externalProxies = entityRecord.getExternalProxies();
        if (externalProxies.size() > 1) {
            throw new HttpBadRequestException("Changing provenance not supported for entity");
        }
        EntityProxy externalProxy = (EntityProxy)externalProxies.get(0);
        String entityType = externalProxy.getEntity().getType();
        entityRecord.getProxies().remove(externalProxy);
        this.setExternalProxy(EntityObjectFactory.createProxyEntityObject((String)entityType), newProxyId, entityRecord.getEntityId(), dataSource, entityRecord, new Date(), 1);
    }

    public void addSameReferenceLinks(Entity entity, List<String> uris) {
        List entitySameReferenceLinks = entity.getSameReferenceLinks();
        if (entitySameReferenceLinks == null) {
            entity.setSameReferenceLinks(new ArrayList<String>(uris));
            return;
        }
        entity.setSameReferenceLinks(Stream.concat(entitySameReferenceLinks.stream(), uris.stream()).distinct().collect(Collectors.toList()));
    }
}

