/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web;

import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.web.EntityIdResponse;
import eu.europeana.entitymanagement.exception.EntityNotFoundException;
import eu.europeana.entitymanagement.exception.EntityRemovedException;
import eu.europeana.entitymanagement.service.EnrichmentService;
import eu.europeana.entitymanagement.web.BaseRest;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/entity/management"})
public class EnrichmentController
extends BaseRest {
    private static final Logger LOG = LogManager.getLogger(EnrichmentController.class);
    @Autowired
    private EnrichmentService entityEnrichmentService;
    @Autowired
    private EntityRecordService entityRecordService;

    @ApiOperation(value="Publish to enrichment", nickname="publishEnrichment", response=Void.class)
    @PostMapping(value={"/enrichment"}, produces={"application/json"})
    public ResponseEntity<EntityIdResponse> publishEnrichment(@RequestParam(value="wskey", required=false) String wskey, @RequestBody List<String> entityList, HttpServletRequest request) throws ApplicationAuthenticationException {
        this.verifyWriteAccess("create", request);
        return this.publishToEnrichment(entityList);
    }

    private ResponseEntity<EntityIdResponse> publishToEnrichment(List<String> entityList) {
        ArrayList<String> entityPublished = new ArrayList<String>();
        for (String entityUri : entityList) {
            Optional entityRecordOptional = this.entityRecordService.retrieveByEntityId(entityUri);
            try {
                if (entityRecordOptional.isEmpty()) {
                    throw new EntityNotFoundException(entityUri);
                }
                EntityRecord entityRecord = (EntityRecord)entityRecordOptional.get();
                if (entityRecord.isDisabled()) {
                    throw new EntityRemovedException(entityUri);
                }
                this.entityEnrichmentService.saveEnrichment(entityRecord);
                entityPublished.add(entityUri);
            }
            catch (EntityNotFoundException | EntityRemovedException e) {
                LOG.error("Error publishing the enrichment for entity. {} ", (Object)e.getMessage());
            }
        }
        return new ResponseEntity((Object)this.prepareEnrichmentResponse(entityList, entityPublished), HttpStatus.OK);
    }

    private EntityIdResponse prepareEnrichmentResponse(List<String> entityList, List<String> entitiesPublished) {
        List<String> successful = null;
        List<String> failed = null;
        long expected = entityList.size();
        if (!entitiesPublished.isEmpty()) {
            successful = entitiesPublished;
        }
        entityList.removeAll(entitiesPublished);
        if (!entityList.isEmpty()) {
            failed = entityList;
        }
        return new EntityIdResponse(expected, successful, failed, Collections.emptyList());
    }
}

