/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import eu.europeana.api.commons.definitions.utils.DateUtils;
import eu.europeana.entitymanagement.web.model.FailedOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

@JsonPropertyOrder(value={"lastSyncDate", "executionStatus", "new", "enabled", "updated", "deprecated", "deleted", "failed"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ZohoSyncReport {
    public static final String STATUS_COMPLETED = "completed";
    public static final String STATUS_INCOMPLETE = "incomplete";
    final Date lastSyncDate;
    long created;
    long enabled;
    long updated;
    long deprecated;
    long deleted;
    private List<FailedOperation> failed;

    public ZohoSyncReport(Date lastSyncDate) {
        this.lastSyncDate = lastSyncDate;
    }

    private ZohoSyncReport() {
        this(new Date(0L));
    }

    @JsonProperty(value="new")
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public void increaseCreated(long created) {
        this.created += created;
    }

    @JsonProperty(value="enabled")
    public long getEnabled() {
        return this.enabled;
    }

    public void setEnabled(long enabled) {
        this.enabled = enabled;
    }

    public void increaseEnabled(long enabled) {
        this.enabled += enabled;
    }

    @JsonProperty(value="updated")
    public long getUpdated() {
        return this.updated;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public void increaseUpdated(long updated) {
        this.updated += updated;
    }

    @JsonProperty(value="deprecated")
    public long getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(long deprecated) {
        this.deprecated = deprecated;
    }

    public void increaseDeprecated(long deprecated) {
        this.deprecated += deprecated;
    }

    @JsonProperty(value="deleted")
    public long getDeleted() {
        return this.deleted;
    }

    public void setDeleted(long deleted) {
        this.deleted = deleted;
    }

    public void increaseDeleted(long deleted) {
        this.deleted += deleted;
    }

    @JsonProperty(value="executionStatus")
    public String getExecutionStatus() {
        if (this.getFailed() == null || this.getFailed().isEmpty()) {
            return STATUS_COMPLETED;
        }
        return STATUS_INCOMPLETE;
    }

    public String toString() {
        return String.format("lastSyncDate: %s,%n created: %d,%n enabled: %d, %n updated: %d,%n deprecated: %d,%n deleted: %d,%n executionStatus: %s", DateUtils.convertDateToStr((Date)this.getLastSyncDate()), this.getCreated(), this.getEnabled(), this.getUpdated(), this.getDeprecated(), this.getDeleted(), this.getExecutionStatus());
    }

    @JsonProperty(value="lastSyncDate")
    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    private void addFailedOperation(FailedOperation operation) {
        if (this.failed == null) {
            this.failed = new ArrayList<FailedOperation>();
        }
        this.failed.add(operation);
    }

    public void addFailedOperation(String id, String error, Throwable th) {
        this.addFailedOperation(id, error, th.getMessage(), th);
    }

    public void addFailedOperation(String id, String error, String message, Throwable th) {
        String trace;
        String string = trace = th == null ? null : ExceptionUtils.getStackTrace((Throwable)th);
        if (error == null && th != null) {
            error = th.getClass().getSimpleName();
        }
        FailedOperation failedOperation = new FailedOperation(id, error, message, trace);
        this.addFailedOperation(failedOperation);
    }

    @JsonProperty(value="failed")
    public List<FailedOperation> getFailed() {
        return this.failed;
    }
}

