/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.config;

import eu.europeana.entitymanagement.batch.config.EntityUpdateJobConfig;
import eu.europeana.entitymanagement.batch.utils.BatchUtils;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledRemovalType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledUpdateType;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:entitymanagement.properties"}), @PropertySource(value={"classpath:entitymanagement.user.properties"}, ignoreResourceNotFound=true)})
@EnableScheduling
public class EntityUpdateSchedulingConfig
implements InitializingBean {
    private static final Logger logger = LogManager.getLogger(EntityUpdateSchedulingConfig.class);
    private final JobLauncher entityUpdateJobLauncher;
    private final JobLauncher entityDeletionsJobLauncher;
    private final EntityUpdateJobConfig updateJobConfig;
    private final TaskScheduler updatesScheduler;
    private final TaskScheduler removalsScheduler;
    @Value(value="${batch.scheduling.metrics.initialDelaySeconds}")
    private long metricsUpdateInitialDelay;
    @Value(value="${batch.scheduling.full.initialDelaySeconds}")
    private long fullUpdateInitialDelay;
    @Value(value="${batch.scheduling.deletion.initialDelaySeconds}")
    private long deletionInitialDelay;
    @Value(value="${batch.scheduling.deprecation.initialDelaySeconds}")
    private long deprecationInitialDelay;
    @Value(value="${batch.scheduling.intervalSeconds}")
    private long interval;
    @Value(value="${batch.scheduling.enabled}")
    private boolean syncEnabled;

    public EntityUpdateSchedulingConfig(@Qualifier(value="entityUpdateJobLauncher") JobLauncher entityUpdateJobLauncher, @Qualifier(value="entityRemovalsJobLauncher") JobLauncher entityDeletionsJobLauncher, EntityUpdateJobConfig batchUpdateConfig, @Qualifier(value="periodicUpdatesScheduler") TaskScheduler updatesScheduler, @Qualifier(value="periodicRemovalsScheduler") TaskScheduler removalsScheduler) {
        this.entityUpdateJobLauncher = entityUpdateJobLauncher;
        this.entityDeletionsJobLauncher = entityDeletionsJobLauncher;
        this.updateJobConfig = batchUpdateConfig;
        this.updatesScheduler = updatesScheduler;
        this.removalsScheduler = removalsScheduler;
    }

    public void afterPropertiesSet() {
        if (this.syncEnabled) {
            String metricsInitialDelayString = this.toMinutesAndSeconds(this.metricsUpdateInitialDelay);
            String fullUpdateInitialDelayString = this.toMinutesAndSeconds(this.fullUpdateInitialDelay);
            String deletionInitialDelayString = this.toMinutesAndSeconds(this.deletionInitialDelay);
            String deprecationInitialDelayString = this.toMinutesAndSeconds(this.deprecationInitialDelay);
            String intervalString = this.toMinutesAndSeconds(this.interval);
            logger.info("Batch scheduling initialized \u2013 metricsUpdateInitialDelay: {}; fullUpdateInitialDelay: {}; deletionInitialDelay: {}; deprecationInitialDelay: {}interval: {}", (Object)metricsInitialDelayString, (Object)fullUpdateInitialDelayString, (Object)deletionInitialDelayString, (Object)deprecationInitialDelayString, (Object)intervalString);
            this.schedulePeriodicUpdates();
            this.schedulePeriodicDeletions();
        } else {
            logger.warn("Batch scheduling disabled. Entities will not be automatically updated.");
        }
    }

    private void schedulePeriodicDeletions() {
        this.removalsScheduler.scheduleWithFixedDelay(this::runScheduledDeprecation, Instant.now().plusSeconds(this.deprecationInitialDelay), Duration.ofSeconds(this.interval));
        this.removalsScheduler.scheduleWithFixedDelay(this::runScheduledDeletions, Instant.now().plusSeconds(this.deletionInitialDelay), Duration.ofSeconds(this.interval));
    }

    private void schedulePeriodicUpdates() {
        this.updatesScheduler.scheduleWithFixedDelay(this::runScheduledFullUpdate, Instant.now().plusSeconds(this.fullUpdateInitialDelay), Duration.ofSeconds(this.interval));
        this.updatesScheduler.scheduleWithFixedDelay(this::runScheduledMetricsUpdate, Instant.now().plusSeconds(this.metricsUpdateInitialDelay), Duration.ofSeconds(this.interval));
    }

    @Async
    void runScheduledFullUpdate() {
        logger.info("Triggering scheduled full update for entities");
        try {
            this.entityUpdateJobLauncher.run(this.updateJobConfig.updateScheduledEntities(ScheduledUpdateType.FULL_UPDATE), BatchUtils.createJobParameters(null, Date.from(Instant.now()), (ScheduledTaskType)ScheduledUpdateType.FULL_UPDATE, false));
        }
        catch (Exception e) {
            logger.warn("Error running scheduled full update", (Throwable)e);
        }
    }

    @Async
    void runScheduledMetricsUpdate() {
        logger.info("Triggering scheduled metrics update for entities");
        try {
            this.entityUpdateJobLauncher.run(this.updateJobConfig.updateScheduledEntities(ScheduledUpdateType.METRICS_UPDATE), BatchUtils.createJobParameters(null, Date.from(Instant.now()), (ScheduledTaskType)ScheduledUpdateType.METRICS_UPDATE, false));
        }
        catch (Exception e) {
            logger.warn("Error running scheduled metrics update", (Throwable)e);
        }
    }

    @Async
    void runScheduledDeletions() {
        logger.info("Triggering scheduled deletions for entities");
        try {
            this.entityDeletionsJobLauncher.run(this.updateJobConfig.removeScheduledEntities(ScheduledRemovalType.PERMANENT_DELETION), BatchUtils.createJobParameters(null, Date.from(Instant.now()), (ScheduledTaskType)ScheduledRemovalType.PERMANENT_DELETION, false));
        }
        catch (Exception e) {
            logger.warn("Error running scheduled deletion", (Throwable)e);
        }
    }

    @Async
    void runScheduledDeprecation() {
        logger.info("Triggering scheduled deprecation for entities");
        try {
            this.entityDeletionsJobLauncher.run(this.updateJobConfig.removeScheduledEntities(ScheduledRemovalType.DEPRECATION), BatchUtils.createJobParameters(null, Date.from(Instant.now()), (ScheduledTaskType)ScheduledRemovalType.DEPRECATION, false));
        }
        catch (Exception e) {
            logger.warn("Error running scheduled deprecation", (Throwable)e);
        }
    }

    private String toMinutesAndSeconds(long seconds) {
        return String.format("%d min, %d sec", TimeUnit.SECONDS.toMinutes(seconds), seconds - TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(seconds)));
    }
}

