/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.entitymanagement.exception.DatasourceDereferenceException;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import eu.europeana.entitymanagement.web.xml.model.metis.EnrichmentResultBaseWrapper;
import eu.europeana.entitymanagement.web.xml.model.metis.EnrichmentResultList;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class MetisDereferenceUtils {
    public static XmlBaseEntityImpl<?> parseMetisResponse(Unmarshaller unmarshaller, String id, String metisResponseBody) throws EuropeanaApiException {
        EnrichmentResultList derefResult;
        try {
            derefResult = (EnrichmentResultList)unmarshaller.unmarshal((Reader)new StringReader(metisResponseBody));
        }
        catch (RuntimeException | JAXBException e2) {
            throw new DatasourceDereferenceException(String.format("Error while deserializing metis dereference response for uri '%s'", id), e2);
        }
        if (derefResult == null || derefResult.getEnrichmentBaseResultWrapperList().isEmpty() || ((EnrichmentResultBaseWrapper)derefResult.getEnrichmentBaseResultWrapperList().get(0)).getEnrichmentBaseList().isEmpty()) {
            return null;
        }
        Optional<XmlBaseEntityImpl> entityOptional = ((EnrichmentResultBaseWrapper)derefResult.getEnrichmentBaseResultWrapperList().get(0)).getEnrichmentBaseList().stream().filter(e -> id.equals(e.getAbout()) || e.hasCoref(id)).findFirst();
        if (entityOptional.isEmpty()) {
            throw new DatasourceDereferenceException(String.format("No match in Metis dereference response for uri '%s'", id));
        }
        return entityOptional.get();
    }
}

