/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.api.commons.web.controller.BaseRestController;
import eu.europeana.corelib.edm.model.schemaorg.Thing;
import eu.europeana.entitymanagement.batch.service.FailedTaskService;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.exception.EtagMismatchException;
import eu.europeana.entitymanagement.exception.HttpBadRequestException;
import eu.europeana.entitymanagement.normalization.EntityFieldsCleaner;
import eu.europeana.entitymanagement.normalization.EntityFieldsEuropeanaProxyValidationGroup;
import eu.europeana.entitymanagement.schemaorg.model.SchemaOrgEntity;
import eu.europeana.entitymanagement.serialization.EntityXmlSerializer;
import eu.europeana.entitymanagement.serialization.JsonLdSerializer;
import eu.europeana.entitymanagement.utils.EntityObjectFactory;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.vocabulary.EntityFieldsTypes;
import eu.europeana.entitymanagement.vocabulary.EntityProfile;
import eu.europeana.entitymanagement.vocabulary.FormatTypes;
import eu.europeana.entitymanagement.web.model.ZohoSyncReport;
import eu.europeana.entitymanagement.web.service.EMAuthorizationService;
import eu.europeana.entitymanagement.web.service.RequestPathMethodService;
import eu.europeana.entitymanagement.web.xml.model.RdfBaseWrapper;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ValidatorFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;

public abstract class BaseRest
extends BaseRestController {
    @Autowired
    private EMAuthorizationService emAuthorizationService;
    @Autowired
    private BuildProperties emBuildInfo;
    @Autowired
    private EntityXmlSerializer entityXmlSerializer;
    @Autowired
    private JsonLdSerializer jsonLdSerializer;
    @Autowired
    private eu.europeana.corelib.edm.utils.JsonLdSerializer corelibJsonLdSerializer;
    @Autowired
    private RequestPathMethodService requestMethodService;
    @Autowired
    protected FailedTaskService failedTaskService;
    @Autowired
    protected ValidatorFactory emValidatorFactory;
    @Autowired
    protected EntityFieldsCleaner emEntityFieldCleaner;
    protected Logger logger = LogManager.getLogger(this.getClass());

    protected EMAuthorizationService getAuthorizationService() {
        return this.emAuthorizationService;
    }

    protected String getApiVersion() {
        return this.emBuildInfo.getVersion();
    }

    protected String serialize(List<EntityRecord> entityRecords) throws EuropeanaApiException {
        String responseBody = null;
        try {
            responseBody = this.jsonLdSerializer.serializeEntities(entityRecords);
        }
        catch (IOException e) {
            throw new EuropeanaApiException("Error serializing entities", (Throwable)e);
        }
        return responseBody;
    }

    protected String serialize(EntityRecord entityRecord, FormatTypes format, List<EntityProfile> profiles) throws EuropeanaApiException {
        String responseBody = null;
        try {
            if (FormatTypes.jsonld.equals((Object)format)) {
                boolean includeFailure = profiles.contains(EntityProfile.debug);
                Optional failure = includeFailure ? this.failedTaskService.getFailure(entityRecord.getEntityId()) : Optional.empty();
                responseBody = this.jsonLdSerializer.serialize(entityRecord, profiles, includeFailure, failure);
            } else if (FormatTypes.xml.equals((Object)format)) {
                XmlBaseEntityImpl xmlEntity = EntityObjectFactory.createXmlEntity((Entity)entityRecord.getEntity());
                responseBody = this.entityXmlSerializer.serializeXmlExternal(new RdfBaseWrapper(xmlEntity));
            } else if (FormatTypes.schema.equals((Object)format)) {
                SchemaOrgEntity schemaOrgEntity = EntityObjectFactory.createSchemaOrgEntity((Entity)entityRecord.getEntity());
                responseBody = this.corelibJsonLdSerializer.serialize((Thing)schemaOrgEntity.get());
            }
        }
        catch (IOException e) {
            throw new EuropeanaApiException("Error serializing entity", (Throwable)e);
        }
        return responseBody;
    }

    protected ResponseEntity<String> generateResponseFailedUpdates(HttpServletRequest request, List<String> entityIds, String wskey) throws EuropeanaApiException {
        HttpHeaders headers = this.createAllowHeader(request);
        if (StringUtils.hasLength((String)request.getHeader("Origin"))) {
            headers.setAccessControlExposeHeaders(List.of("ETag", "Vary"));
        }
        headers.add("Content-Type", "application/ld+json;charset=utf-8");
        StringBuffer requestUrl = request.getRequestURL();
        String entityUriPrefix = requestUrl.subSequence(0, requestUrl.length() - 17).toString();
        String wskeyParam = StringUtils.hasLength((String)wskey) ? String.format("&%s=%s", "wskey", wskey) : "";
        String entityUrlSuffix = ".jsonld?profile=debug,internal" + wskeyParam;
        List pathUrls = entityIds.stream().map(id -> entityUriPrefix + EntityRecordUtils.getEntityRequestPath((String)id) + entityUrlSuffix).collect(Collectors.toList());
        try {
            String body = this.jsonLdSerializer.serializeFailedUpdates(pathUrls);
            headers.setContentLength((long)body.getBytes().length);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).body((Object)body);
        }
        catch (IOException e) {
            throw new EuropeanaApiException("Error serializing failed tasks", (Throwable)e);
        }
    }

    protected ResponseEntity<String> generateZohoSyncResponse(HttpServletRequest request, ZohoSyncReport zohoSyncReport) throws EuropeanaApiException {
        HttpHeaders headers = this.createAllowHeader(request);
        headers.add("Content-Type", "application/ld+json;charset=utf-8");
        try {
            String body = this.jsonLdSerializer.serializeObject((Object)zohoSyncReport);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).body((Object)body);
        }
        catch (IOException e) {
            throw new EuropeanaApiException("Error serializing failed tasks", (Throwable)e);
        }
    }

    protected ResponseEntity<String> generateResponseEntity(HttpServletRequest request, List<EntityProfile> profiles, FormatTypes outFormat, String languages, String contentType, EntityRecord entityRecord, HttpStatus status) throws EuropeanaApiException {
        Aggregation isAggregatedBy = entityRecord.getEntity().getIsAggregatedBy();
        long timestamp = isAggregatedBy != null ? isAggregatedBy.getModified().getTime() : 0L;
        String etag = this.computeEtag(timestamp, outFormat.name(), this.getApiVersion());
        String requestUri = request.getRequestURI();
        boolean hasPathExtension = requestUri.endsWith("." + FormatTypes.jsonld) || requestUri.endsWith("." + FormatTypes.xml);
        HttpHeaders headers = this.createAllowHeader(request);
        headers.add("Link", "<http://www.w3.org/ns/ldp#Resource>; rel=\"type\"");
        if (!hasPathExtension) {
            headers.add("Vary", "Accept");
        }
        if (StringUtils.hasLength((String)request.getHeader("Origin"))) {
            headers.add("Access-Control-Expose-Headers", "Link");
            if (!hasPathExtension) {
                headers.add("Access-Control-Expose-Headers", "Vary");
            }
            headers.add("Access-Control-Expose-Headers", "ETag");
        }
        if (contentType != null && !contentType.isEmpty()) {
            headers.add("Content-Type", contentType);
        }
        this.processLanguage(entityRecord.getEntity(), languages);
        String body = this.serialize(entityRecord, outFormat, profiles);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(headers)).eTag(etag)).body((Object)body);
    }

    protected HttpHeaders createAllowHeader(HttpServletRequest request) {
        String allowHeaderValue;
        HttpHeaders headers = new HttpHeaders();
        Optional methodsForRequestPattern = this.requestMethodService.getMethodsForRequestPattern(request);
        if (methodsForRequestPattern.isEmpty()) {
            this.logger.warn("Could not find other matching methods for {}. Using current request method in Allow header", (Object)request.getRequestURL());
            allowHeaderValue = request.getMethod();
        } else {
            allowHeaderValue = (String)methodsForRequestPattern.get();
        }
        headers.add("Allow", allowHeaderValue);
        return headers;
    }

    protected ResponseEntity<String> noContentResponse(HttpServletRequest request) {
        return ResponseEntity.noContent().headers(this.createAllowHeader(request)).build();
    }

    protected String computeEtag(long timestamp, String format, String version) {
        return DigestUtils.md5Hex((String)String.format("%s:%s:%s", timestamp, format, version));
    }

    private void processLanguage(Entity entity, String languages) throws EuropeanaApiException {
        if (languages == null || languages.isEmpty()) {
            return;
        }
        List<String> languagesList = Arrays.asList(languages.split(",", -1));
        List entityFields = EntityUtils.getAllFields(entity.getClass());
        String fieldName = null;
        try {
            for (Field field : entityFields) {
                Map currentFieldValue;
                fieldName = field.getName();
                if (!EntityFieldsTypes.isMultilingual((String)fieldName) || (currentFieldValue = (Map)entity.getFieldValue(field)) == null) continue;
                HashMap newFieldValue = new HashMap();
                for (Map.Entry mapEntry : currentFieldValue.entrySet()) {
                    if (!languagesList.contains(mapEntry.getKey()) && !((String)mapEntry.getKey()).equals("")) continue;
                    newFieldValue.put((String)mapEntry.getKey(), mapEntry.getValue());
                }
                if (currentFieldValue.size() == newFieldValue.size()) continue;
                entity.setFieldValue(field, newFieldValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new EuropeanaApiException("An exception occurred during setting the entity field: " + fieldName, (Throwable)e);
        }
    }

    protected void checkIfMatchHeaderWithQuotes(String etag, HttpServletRequest request) throws EtagMismatchException {
        String ifMatchHeader = request.getHeader("If-Match");
        if (ifMatchHeader != null && !etag.equals(ifMatchHeader.replace("\"", ""))) {
            throw new EtagMismatchException("If-Match header value does not match generated ETag for entity");
        }
    }

    protected boolean containsSyncProfile(String profile) {
        return StringUtils.hasLength((String)profile) && Arrays.asList(profile.split(",")).contains("sync");
    }

    protected void validateBodyEntity(Entity entity) throws HttpBadRequestException {
        Set violations = this.emValidatorFactory.getValidator().validate((Object)entity, new Class[]{EntityFieldsEuropeanaProxyValidationGroup.class});
        if (!violations.isEmpty()) {
            String requestEntityViolations = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(" "));
            throw new HttpBadRequestException(requestEntityViolations);
        }
    }
}

