/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.service;

import com.mongodb.bulk.BulkWriteResult;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.internal.MorphiaCursor;
import eu.europeana.entitymanagement.batch.repository.ScheduledTaskRepository;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTask;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduledTaskService {
    private final ScheduledTaskRepository repository;
    private static final Logger logger = LogManager.getLogger(ScheduledTaskService.class);

    @Autowired
    public ScheduledTaskService(ScheduledTaskRepository repository) {
        this.repository = repository;
    }

    public void scheduleTasksForEntities(List<String> entityIds, ScheduledTaskType updateType) {
        List tasks = this.createScheduledTasks(entityIds, updateType, false);
        BulkWriteResult writeResult = this.repository.upsertBulk(tasks);
        logger.info("Persisted scheduled tasks to db: matched={}, modified={}, inserted={}, updateType={}", (Object)writeResult.getMatchedCount(), (Object)writeResult.getModifiedCount(), (Object)writeResult.getInsertedCount(), (Object)updateType);
    }

    public void markAsProcessed(List<String> entityIds, ScheduledTaskType updateType) {
        List tasks = this.createScheduledTasks(entityIds, updateType, true);
        BulkWriteResult writeResult = this.repository.markAsProcessed(updateType, tasks);
        logger.info("Marked scheduled tasks as processed: matched={}, modified={}, inserted={}, updateType={}", (Object)writeResult.getMatchedCount(), (Object)writeResult.getModifiedCount(), (Object)writeResult.getInsertedCount(), (Object)updateType);
    }

    public void removeProcessedTasks(ScheduledTaskType updateType) {
        long removeCount = this.repository.removeProcessedTasks(updateType);
        if (removeCount > 0L && logger.isDebugEnabled()) {
            logger.debug("Removed scheduled tasks from db: count={}, updateType={}", (Object)removeCount, (Object)updateType);
        }
    }

    public void removeScheduledTasksWithFailures(int maxFailedTaskRetries, ScheduledTaskType updateType) {
        try (MorphiaCursor cursor = this.repository.getTasksWithFailures(maxFailedTaskRetries, updateType);){
            while (cursor.hasNext()) {
                this.repository.deleteScheduledTask(((ScheduledTask)cursor.next()).getEntityId());
            }
        }
    }

    public List<? extends EntityRecord> getEntityRecordsForTasks(int start, int count, Filter[] queryFilters) {
        return this.repository.getEntityRecordsForTasks(start, count, queryFilters);
    }

    public Optional<ScheduledTask> getTask(String entityId) {
        return Optional.ofNullable(this.repository.getTask(entityId));
    }

    public List<ScheduledTask> getTasks(List<String> entityIds) {
        return this.repository.getTasks(entityIds);
    }

    private List<ScheduledTask> createScheduledTasks(List<String> entityIds, ScheduledTaskType updateType, boolean hasBeenProcessed) {
        Instant now = Instant.now();
        return entityIds.stream().map(entityId -> new ScheduledTask.Builder(entityId, updateType).setProcessed(hasBeenProcessed).modified(now).build()).collect(Collectors.toList());
    }

    public void dropCollection() {
        this.repository.dropCollection();
    }
}

