/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.repository;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import dev.morphia.Datastore;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.experimental.updates.UpdateOperators;
import eu.europeana.entitymanagement.definitions.batch.EMBatchConstants;
import eu.europeana.entitymanagement.definitions.batch.model.FailedTask;
import eu.europeana.entitymanagement.mongo.utils.MorphiaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class FailedTaskRepository
implements InitializingBean {
    private final Datastore datastore;

    @Autowired
    public FailedTaskRepository(@Qualifier(value="emDataStore") Datastore datastore) {
        this.datastore = datastore;
    }

    public void afterPropertiesSet() {
        this.datastore.ensureIndexes(FailedTask.class);
    }

    public UpdateResult upsert(FailedTask failure) {
        return this.datastore.find(FailedTask.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)failure.getEntityId())}).update(UpdateOperators.set((String)"entityId", (Object)failure.getEntityId()), new UpdateOperator[]{UpdateOperators.set((String)"stackTrace", (Object)failure.getStackTrace()), UpdateOperators.set((String)"errorMessage", (Object)failure.getErrorMessage()), UpdateOperators.set((String)"modified", (Object)failure.getModified()), UpdateOperators.set((String)"updateType", (Object)failure.getUpdateType().getValue()), UpdateOperators.inc((String)"failureCount", (Number)1), UpdateOperators.setOnInsert(Map.of("created", failure.getModified()))}).execute(MorphiaUtils.UPSERT_OPTS);
    }

    public BulkWriteResult upsertBulk(List<FailedTask> failures) {
        MongoCollection collection = this.datastore.getMapper().getCollection(FailedTask.class);
        ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>();
        for (FailedTask failure : failures) {
            updates.add(new UpdateOneModel((Bson)new Document("entityId", (Object)failure.getEntityId()), (Bson)new Document("$set", (Object)new Document("entityId", (Object)failure.getEntityId()).append("modified", (Object)failure.getModified()).append("errorMessage", (Object)failure.getErrorMessage()).append("stackTrace", (Object)failure.getStackTrace())).append("$inc", (Object)new Document("failureCount", (Object)1)).append("$setOnInsert", (Object)new Document(Map.of("created", failure.getModified(), "_t", EMBatchConstants.FAILED_TASK_CLASSNAME))), (UpdateOptions)MorphiaUtils.UPSERT_OPTS));
        }
        return collection.bulkWrite(updates);
    }

    public long removeFailures(List<String> entityIds) {
        return this.datastore.find(FailedTask.class).filter(new Filter[]{Filters.in((String)"entityId", entityIds)}).delete(MorphiaUtils.MULTI_DELETE_OPTS).getDeletedCount();
    }

    public List<String> getEntityIdsWithFailures(int start, int count) {
        List failedTasks = this.datastore.find(FailedTask.class).iterator(new FindOptions().projection().include(new String[]{"entityId"}).skip(start).sort(new Sort[]{Sort.ascending((String)"created")}).limit(count)).toList();
        return failedTasks.stream().map(FailedTask::getEntityId).collect(Collectors.toList());
    }

    public FailedTask getFailure(String entityId) {
        return (FailedTask)this.datastore.find(FailedTask.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).first();
    }

    public List<FailedTask> getFailures(List<String> entityIds) {
        return this.datastore.find(FailedTask.class).filter(new Filter[]{Filters.in((String)"entityId", entityIds)}).iterator().toList();
    }

    public void dropCollection() {
        this.datastore.getMapper().getCollection(FailedTask.class).drop();
    }
}

