/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.processor;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.exception.ingestion.EntityValidationException;
import eu.europeana.entitymanagement.normalization.EntityFieldsCleaner;
import eu.europeana.entitymanagement.normalization.EntityFieldsCompleteValidationGroup;
import eu.europeana.entitymanagement.normalization.EntityFieldsDataSourceProxyValidationGroup;
import eu.europeana.entitymanagement.utils.EntityObjectFactory;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidatorFactory;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class EntityConsolidationProcessor
implements ItemProcessor<EntityRecord, EntityRecord> {
    private final EntityRecordService entityRecordService;
    private final ValidatorFactory emValidatorFactory;
    private final EntityFieldsCleaner emEntityFieldCleaner;
    private final DataSources datasources;

    public EntityConsolidationProcessor(EntityRecordService entityRecordService, ValidatorFactory emValidatorFactory, EntityFieldsCleaner emEntityFieldCleaner, DataSources datasources) {
        this.entityRecordService = entityRecordService;
        this.emValidatorFactory = emValidatorFactory;
        this.emEntityFieldCleaner = emEntityFieldCleaner;
        this.datasources = datasources;
    }

    public EntityRecord process(@NonNull EntityRecord entityRecord) throws EuropeanaApiException {
        boolean isStaticDataSource;
        List externalProxies = entityRecord.getExternalProxies();
        Entity externalProxyEntity = ((EntityProxy)externalProxies.get(0)).getEntity();
        String proxyId = ((EntityProxy)externalProxies.get(0)).getProxyId();
        Optional dataSource = this.datasources.getDatasource(proxyId);
        boolean bl = isStaticDataSource = dataSource.isPresent() && ((DataSource)dataSource.get()).isStatic();
        if (!isStaticDataSource) {
            this.validateDataSourceProxyConstraints(externalProxyEntity);
        }
        if (externalProxies.size() > 1) {
            for (int i = 1; i < externalProxies.size(); ++i) {
                Entity secondaryProxyEntity = ((EntityProxy)externalProxies.get(i)).getEntity();
                this.validateDataSourceProxyConstraints(secondaryProxyEntity);
                externalProxyEntity = this.entityRecordService.mergeEntities(externalProxyEntity, secondaryProxyEntity);
            }
        }
        Entity europeanaProxyEntity = entityRecord.getEuropeanaProxy().getEntity();
        Entity consolidatedEntity = null;
        consolidatedEntity = isStaticDataSource ? EntityObjectFactory.createConsolidatedEntityObject((Entity)europeanaProxyEntity) : this.entityRecordService.mergeEntities(europeanaProxyEntity, externalProxyEntity);
        this.entityRecordService.addSameReferenceLinks(consolidatedEntity, externalProxies.stream().map(EntityProxy::getProxyId).collect(Collectors.toList()));
        this.emEntityFieldCleaner.cleanAndNormalize(consolidatedEntity);
        this.entityRecordService.performReferentialIntegrity(consolidatedEntity);
        this.validateCompleteValidationConstraints(consolidatedEntity);
        this.entityRecordService.updateConsolidatedVersion(entityRecord, consolidatedEntity);
        return entityRecord;
    }

    private void validateCompleteValidationConstraints(Entity entity) throws EntityValidationException {
        Set violations = this.emValidatorFactory.getValidator().validate((Object)entity, new Class[]{EntityFieldsCompleteValidationGroup.class});
        if (!violations.isEmpty()) {
            throw new EntityValidationException("The consolidated entity contains invalid data!", violations);
        }
    }

    private void validateDataSourceProxyConstraints(Entity entity) throws EntityValidationException {
        Set violations = this.emValidatorFactory.getValidator().validate((Object)entity, new Class[]{EntityFieldsDataSourceProxyValidationGroup.class});
        if (!violations.isEmpty()) {
            throw new EntityValidationException("The entity from the external data source contains invalid data!", violations);
        }
    }
}

