/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.config;

import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SolrConfig {
    private static final Logger logger = LogManager.getLogger(SolrConfig.class);
    private final EntityManagementConfiguration emConfiguration;

    @Autowired
    public SolrConfig(EntityManagementConfiguration emConfiguration) {
        this.emConfiguration = emConfiguration;
    }

    @Bean(value={"prSolrClient"})
    public SolrClient pageRankSolrClient() {
        logger.info("Configuring pageRank solr client at the url: {}", (Object)this.emConfiguration.getPrSolrUrl());
        return new HttpSolrClient.Builder(this.emConfiguration.getPrSolrUrl()).build();
    }

    @Bean(value={"indexingSolrClient"})
    public SolrClient indexingSolrClient() {
        logger.info("Configuring indexing solr client at the url: {}", (Object)this.emConfiguration.getIndexingSolrUrl());
        return new HttpSolrClient.Builder(this.emConfiguration.getIndexingSolrUrl()).build();
    }
}

