/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.batch.processor;

import eu.europeana.entitymanagement.common.config.DataSource;
import eu.europeana.entitymanagement.config.DataSources;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.dereference.Dereferencer;
import eu.europeana.entitymanagement.exception.DatasourceDereferenceException;
import eu.europeana.entitymanagement.exception.EntityMismatchException;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.service.DereferenceServiceLocator;
import eu.europeana.entitymanagement.web.service.EntityRecordService;
import eu.europeana.entitymanagement.zoho.utils.WikidataUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class EntityDereferenceProcessor
implements ItemProcessor<EntityRecord, EntityRecord> {
    private static final String MISMATCH_EXCEPTION_STRING = "DataSource type %s does not match entity type %s for entityId=%s, proxyId=%s";
    private static final Logger logger = LogManager.getLogger(EntityDereferenceProcessor.class);
    private final DereferenceServiceLocator dereferenceServiceLocator;
    private final DataSources datasources;
    private final EntityRecordService entityRecordService;

    @Autowired
    public EntityDereferenceProcessor(DereferenceServiceLocator dereferenceServiceLocator, DataSources datasources, EntityRecordService entityRecordService) {
        this.dereferenceServiceLocator = dereferenceServiceLocator;
        this.datasources = datasources;
        this.entityRecordService = entityRecordService;
    }

    public EntityRecord process(@NonNull EntityRecord entityRecord) throws Exception {
        TreeSet<String> wikidataEntityIds = new TreeSet<String>();
        this.collectWikidataEntityIds(entityRecord.getEuropeanaProxy().getEntity(), wikidataEntityIds);
        for (EntityProxy externalProxy : entityRecord.getExternalProxies()) {
            Optional<DataSource> dataSource = this.datasources.getDatasource(externalProxy.getProxyId());
            if (dataSource.isPresent() && dataSource.get().isStatic()) continue;
            Entity externalEntity = this.dereferenceAndUpdateProxy(externalProxy, entityRecord);
            this.collectWikidataEntityIds(externalEntity, wikidataEntityIds);
        }
        if (EntityTypes.Organization.getEntityType().equals(entityRecord.getEntity().getType())) {
            this.handleWikidataReferenceChange(wikidataEntityIds, entityRecord);
        }
        return entityRecord;
    }

    void handleWikidataReferenceChange(TreeSet<String> wikidataEntityIds, EntityRecord entityRecord) throws Exception {
        EntityProxy wikidataProxy = entityRecord.getWikidataProxy();
        if (!(wikidataProxy == null && wikidataEntityIds.isEmpty() || wikidataProxy != null && wikidataEntityIds.contains(wikidataProxy.getProxyId()) || wikidataEntityIds.isEmpty())) {
            String wikidataId = wikidataEntityIds.first();
            if (wikidataProxy == null) {
                EntityProxy newProxy = this.addWikidataProxyAndDeref(wikidataId, entityRecord);
                if (logger.isInfoEnabled()) {
                    logger.info("For Entity Record with id:{}, wikidata proxy with id: {}  was created", (Object)entityRecord.getEntityId(), (Object)newProxy.getProxyId());
                }
            } else if (!wikidataEntityIds.contains(wikidataProxy.getProxyId())) {
                boolean hasRedirectionCoref;
                Optional redirectedWikidataId = WikidataUtils.getWikidataId((List)wikidataProxy.getEntity().getSameReferenceLinks());
                boolean bl = hasRedirectionCoref = redirectedWikidataId.isPresent() && wikidataEntityIds.contains(redirectedWikidataId.get());
                if (hasRedirectionCoref) {
                    String message = "For Entity Record with id:{}, wikidata proxy was not replaced as the proxy id: {} was found in coreferences.";
                    logger.debug(message, (Object)entityRecord.getEntityId(), (Object)wikidataId);
                } else if (logger.isDebugEnabled()) {
                    this.updateWikidataProxies(entityRecord, wikidataId, wikidataProxy, wikidataEntityIds);
                }
            }
        }
    }

    void updateWikidataProxies(EntityRecord entityRecord, String wikidataId, EntityProxy wikidataProxy, TreeSet<String> wikidataEntityIds) throws Exception {
        entityRecord.getProxies().remove(wikidataProxy);
        if (logger.isInfoEnabled()) {
            logger.info("For Entity Record with id:{}, wikidata proxy with id: {}  was removed", (Object)entityRecord.getEntityId(), (Object)wikidataId);
        }
        if (!wikidataEntityIds.isEmpty()) {
            EntityProxy newProxy = this.addWikidataProxyAndDeref(wikidataId, entityRecord);
            if (logger.isInfoEnabled()) {
                logger.info("For Entity Record with id:{}, wikidata proxy was replaced, new proxy id: {}", (Object)entityRecord.getEntityId(), (Object)newProxy.getProxyId());
            }
        }
    }

    private EntityProxy addWikidataProxyAndDeref(String wikidataId, EntityRecord entityRecord) throws Exception {
        EntityProxy wikidataProxy = this.entityRecordService.appendWikidataProxy(entityRecord, wikidataId, entityRecord.getEntity().getType(), new Date());
        this.dereferenceAndUpdateProxy(wikidataProxy, entityRecord);
        return wikidataProxy;
    }

    private void collectWikidataEntityIds(Entity entity, @NonNull TreeSet<String> wikidataEntityIds) {
        List wikidataIds = WikidataUtils.getAllWikidataIds((List)entity.getSameReferenceLinks());
        if (!wikidataIds.isEmpty()) {
            wikidataEntityIds.addAll(wikidataIds);
        }
    }

    private Entity dereferenceAndUpdateProxy(@NonNull EntityProxy externalProxy, @NonNull EntityRecord entityRecord) throws Exception {
        String entityType;
        String entityId = entityRecord.getEntityId();
        String proxyId = externalProxy.getProxyId();
        Dereferencer dereferencer = this.dereferenceServiceLocator.getDereferencer(proxyId, entityType = entityRecord.getEntity().getType());
        Optional proxyResponseOptional = dereferencer.dereferenceEntityById(proxyId);
        if (proxyResponseOptional.isEmpty()) {
            throw new DatasourceDereferenceException("Unsuccessful dereferenciation (empty response) for externalId=" + proxyId + "; entityId=" + entityId);
        }
        Entity proxyResponse = (Entity)proxyResponseOptional.get();
        String proxyResponseType = proxyResponse.getType();
        if (!proxyResponseType.equals(entityType)) {
            throw new EntityMismatchException(String.format(MISMATCH_EXCEPTION_STRING, proxyResponseType, entityType, entityId, proxyId));
        }
        externalProxy.setEntity(proxyResponse);
        this.handleDatasourceRedirections(externalProxy, proxyResponse);
        externalProxy.getProxyIn().setModified(new Date());
        return proxyResponse;
    }

    void handleDatasourceRedirections(EntityProxy externalProxy, Entity proxyResponse) {
        if (!externalProxy.getProxyId().equals(proxyResponse.getEntityId())) {
            proxyResponse.addSameReferenceLink(externalProxy.getProxyId());
            if (logger.isInfoEnabled()) {
                logger.info("Updating proxy id with the actual value from the external entity {} -> {}", (Object)externalProxy.getProxyId(), (Object)proxyResponse.getEntityId());
            }
            externalProxy.setProxyId(proxyResponse.getEntityId());
        }
    }
}

