/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.utils.SolrGeneralUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.solr.client.solrj.beans.Field;

public class SolrOrganization
extends SolrEntity<Organization> {
    @Field(value="owl_sameAs")
    private List<String> sameAs;
    @Field(value="aggregatedVia")
    private List<String> aggregatedVia;
    @Field(value="dc_description.*")
    private Map<String, String> description;
    @Field(value="edm_acronym.*")
    private Map<String, List<String>> acronym;
    @Field(value="foaf_logo")
    private String logo;
    @Field(value="foaf_homepage")
    private String homepage;
    @Field(value="foaf_phone")
    private List<String> phone;
    @Field(value="europeanaRole")
    private List<String> europeanaRole;
    @Field(value="country")
    private List<String> country;
    @Field(value="countryLabel.*")
    private Map<String, String> countryLabel;
    @Field(value="vcard_hasAddress.1")
    private String hasAddress;
    @Field(value="vcard_streetAddress.1")
    private String streetAddress;
    @Field(value="vcard_locality.1")
    private String locality;
    @Field(value="vcard_region.1")
    private String region;
    @Field(value="vcard_postalCode.1")
    private String postalCode;
    @Field(value="vcard_countryName.1")
    private String countryName;
    @Field(value="vcard_postOfficeBox.1")
    private String postBox;
    @Field(value="hasGeo")
    private String hasGeo;

    public SolrOrganization() {
    }

    public SolrOrganization(Organization organization) {
        super(organization);
        Address organizationAddress;
        this.setDescription(organization.getDescription());
        this.setAcronym(organization.getAcronym());
        if (organization.getLogo() != null) {
            this.logo = organization.getLogo().getId();
        }
        this.homepage = organization.getHomepage();
        this.phone = organization.getPhone();
        if (organization.getEuropeanaRoleIds() != null) {
            this.europeanaRole = new ArrayList<String>(organization.getEuropeanaRoleIds());
        }
        this.country = new ArrayList<String>();
        String orgCountryId = organization.getCountryId();
        String orgCountryISO = organization.getCountryISO();
        if (orgCountryId != null) {
            this.country.add(orgCountryId);
        }
        if (orgCountryISO != null) {
            this.country.add(orgCountryISO);
        }
        if (organization.getCountry() != null) {
            this.setCountryLabel(organization.getCountry().getPrefLabel());
        }
        if (organization.getSameReferenceLinks() != null) {
            this.sameAs = new ArrayList<String>(organization.getSameReferenceLinks());
        }
        if (organization.getAggregatedVia() != null) {
            this.aggregatedVia = new ArrayList<String>(organization.getAggregatedVia());
        }
        if ((organizationAddress = organization.getAddress()) != null) {
            this.hasAddress = organizationAddress.getAbout();
            this.streetAddress = organizationAddress.getVcardStreetAddress();
            this.locality = organizationAddress.getVcardLocality();
            this.postalCode = organizationAddress.getVcardPostalCode();
            this.countryName = organizationAddress.getVcardCountryName();
            this.postBox = organizationAddress.getVcardPostOfficeBox();
            this.hasGeo = EntityUtils.toLatLongValue((String)organizationAddress.getVcardHasGeo());
        }
    }

    private void setDescription(Map<String, String> dcDescription) {
        if (MapUtils.isNotEmpty(dcDescription)) {
            this.description = new HashMap<String, String>(SolrGeneralUtils.normalizeStringMapByAddingPrefix((String)"dc_description.", dcDescription));
        }
    }

    private void setAcronym(Map<String, List<String>> acronym) {
        if (MapUtils.isNotEmpty(acronym)) {
            this.acronym = new HashMap<String, List<String>>(SolrGeneralUtils.normalizeStringListMapByAddingPrefix((String)"edm_acronym.", acronym));
        }
    }

    public Map<String, String> getDescription() {
        return this.description;
    }

    public Map<String, List<String>> getAcronym() {
        return this.acronym;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public List<String> getPhone() {
        return this.phone;
    }

    public List<String> getEuropeanaRole() {
        return this.europeanaRole;
    }

    public String getHasAddress() {
        return this.hasAddress;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getPostBox() {
        return this.postBox;
    }

    public String getHasGeo() {
        return this.hasGeo;
    }

    @Override
    protected void setSameReferenceLinks(ArrayList<String> uris) {
        this.sameAs = uris;
    }

    public List<String> getAggregatedVia() {
        return this.aggregatedVia;
    }

    public List<String> getCountry() {
        return this.country;
    }

    public Map<String, String> getCountryLabel() {
        return this.countryLabel;
    }

    public void setCountryLabel(Map<String, String> countryLabel) {
        if (MapUtils.isNotEmpty(countryLabel)) {
            this.countryLabel = new HashMap<String, String>(SolrGeneralUtils.normalizeStringMapByAddingPrefix((String)"countryLabel.", countryLabel));
        }
    }
}

