/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.utils.SolrGeneralUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.solr.client.solrj.beans.Field;

public abstract class SolrEntity<T extends Entity> {
    private T entity;
    @Field(value="type")
    private String type;
    @Field(value="id")
    private String entityId;
    @Field(value="foaf_depiction")
    private String depiction;
    @Field(value="skos_note.*")
    private Map<String, List<String>> note;
    @Field(value="skos_prefLabel.*")
    private Map<String, String> prefLabel;
    @Field(value="skos_altLabel.*")
    private Map<String, List<String>> altLabel;
    @Field(value="skos_hiddenLabel.*")
    private Map<String, List<String>> hiddenLabel;
    @Field(value="label_enrich")
    private List<String> labelEnrichGeneral;
    @Field(value="label_enrich.*")
    private Map<String, List<String>> labelEnrich;
    @Field(value="dc_identifier")
    private List<String> identifier;
    @Field(value="edm_isRelatedTo")
    private List<String> isRelatedTo;
    @Field(value="dcterms_hasPart")
    private List<String> hasPart;
    @Field(value="dcterms_isPartOf")
    private List<String> isPartOf;
    @Field(value="payload")
    private String payload;
    @Field(value="isShownBy.*")
    private Map<String, String> isShownBy;
    @Field(value="suggest_filters")
    private List<String> suggestFilters;
    @Field(value="rights")
    private List<String> rights;
    @Field(value="europeana_doc_count")
    private Integer docCount;
    @Field(value="pagerank")
    private Float pageRank;
    @Field(value="derived_score")
    private Float derivedScore;
    @Field(value="skos_inScheme")
    private List<String> inScheme;
    @Field(value="created")
    private Date created;
    @Field(value="modified")
    private Date modified;

    public SolrEntity(T entity) {
        this.type = entity.getType();
        this.entityId = entity.getEntityId();
        if (entity.getDepiction() != null) {
            this.depiction = entity.getDepiction().getId();
        }
        this.setNote(entity.getNote());
        this.setPrefLabelStringMap(entity.getPrefLabel());
        this.setAltLabel(entity.getAltLabel());
        this.setHiddenLabelMap(entity.getHiddenLabel());
        this.setIsShownBy(entity.getIsShownBy());
        if (entity.getIdentifier() != null) {
            this.identifier = new ArrayList<String>(entity.getIdentifier());
        }
        if (entity.getIsRelatedTo() != null) {
            this.isRelatedTo = new ArrayList<String>(entity.getIsRelatedTo());
        }
        if (entity.getHasPart() != null) {
            this.hasPart = new ArrayList<String>(entity.getHasPart());
        }
        if (entity.getIsPartOfArray() != null) {
            this.isPartOf = new ArrayList<String>(entity.getIsPartOfArray());
        }
        if (entity.getInScheme() != null) {
            this.inScheme = new ArrayList<String>(entity.getInScheme());
        }
        if (entity.getIsAggregatedBy() != null) {
            this.created = entity.getIsAggregatedBy().getCreated();
            this.modified = entity.getIsAggregatedBy().getModified();
        }
        this.entity = entity;
    }

    public SolrEntity() {
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    private void setPrefLabelStringMap(Map<String, String> prefLabel) {
        if (MapUtils.isNotEmpty(prefLabel)) {
            this.prefLabel = new HashMap<String, String>(SolrGeneralUtils.normalizeStringMapByAddingPrefix((String)"skos_prefLabel.", prefLabel));
        }
    }

    private void setAltLabel(Map<String, List<String>> altLabel) {
        if (MapUtils.isNotEmpty(altLabel)) {
            this.altLabel = new HashMap<String, List<String>>(SolrGeneralUtils.normalizeStringListMapByAddingPrefix((String)"skos_altLabel.", altLabel));
        }
    }

    public void setHiddenLabelMap(List<String> hiddenLabel) {
        if (hiddenLabel != null && !hiddenLabel.isEmpty()) {
            this.hiddenLabel = new HashMap<String, List<String>>();
            this.hiddenLabel.put("skos_hiddenLabel.", new ArrayList<String>(hiddenLabel));
        }
    }

    private void setNote(Map<String, List<String>> note) {
        if (MapUtils.isNotEmpty(note)) {
            this.note = new HashMap<String, List<String>>(SolrGeneralUtils.normalizeStringListMapByAddingPrefix((String)"skos_note.", note));
        }
    }

    private void setIsShownBy(WebResource webResource) {
        if (webResource == null) {
            return;
        }
        this.isShownBy = new HashMap<String, String>();
        this.isShownBy.put("isShownBy", webResource.getId());
        this.isShownBy.put("isShownBy.source", webResource.getSource());
        this.isShownBy.put("isShownBy.thumbnail", webResource.getThumbnail());
    }

    public String getType() {
        return this.type;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getDepiction() {
        return this.depiction;
    }

    public Map<String, List<String>> getNote() {
        return this.note;
    }

    public Map<String, String> getPrefLabel() {
        return this.prefLabel;
    }

    public Map<String, List<String>> getAltLabel() {
        return this.altLabel;
    }

    public Map<String, List<String>> getHiddenLabel() {
        return this.hiddenLabel;
    }

    public List<String> getIdentifier() {
        return this.identifier;
    }

    public List<String> getIsRelatedTo() {
        return this.isRelatedTo;
    }

    public List<String> getHasPart() {
        return this.hasPart;
    }

    public List<String> getIsPartOf() {
        return this.isPartOf;
    }

    public String getPayload() {
        return this.payload;
    }

    public T getEntity() {
        return this.entity;
    }

    public List<String> getSuggestFilters() {
        return this.suggestFilters;
    }

    public void setSuggestFilters(List<String> suggestFilters) {
        this.suggestFilters = suggestFilters;
    }

    public List<String> getRights() {
        return this.rights;
    }

    public void setRights(List<String> rights) {
        this.rights = rights;
    }

    public Integer getDocCount() {
        return this.docCount;
    }

    public void setDocCount(Integer docCount) {
        this.docCount = docCount;
    }

    public Float getPageRank() {
        return this.pageRank;
    }

    public void setPageRank(Float pageRank) {
        this.pageRank = pageRank;
    }

    public Float getDerivedScore() {
        return this.derivedScore;
    }

    public void setDerivedScore(Float derivedScore) {
        this.derivedScore = derivedScore;
    }

    public List<String> getInScheme() {
        return this.inScheme;
    }

    public void setInScheme(List<String> inScheme) {
        this.inScheme = inScheme;
    }

    protected abstract void setSameReferenceLinks(ArrayList<String> var1);

    public List<String> getLabelEnrichGeneral() {
        return this.labelEnrichGeneral;
    }

    public void setLabelEnrichGeneral(List<String> labelEnrichGeneral) {
        this.labelEnrichGeneral = labelEnrichGeneral;
    }

    public Map<String, List<String>> getLabelEnrich() {
        return this.labelEnrich;
    }

    public void setLabelEnrich(Map<String, List<String>> labelEnrich) {
        if (MapUtils.isNotEmpty(labelEnrich)) {
            this.labelEnrich = new HashMap<String, List<String>>(SolrGeneralUtils.normalizeStringListMapByAddingPrefix((String)"label_enrich.", labelEnrich));
        }
    }

    public Date getCreated() {
        return (Date)this.created.clone();
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getModified() {
        return (Date)this.modified.clone();
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }
}

