/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import eu.europeana.entitymanagement.definitions.model.Aggregator;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.solr.model.SolrOrganization;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.beans.Field;

public class SolrAggregator
extends SolrOrganization {
    @Field(value="mbox")
    private String mbox;
    @Field(value="geographicScope")
    private String geographicScope;
    @Field(value="heritageDomain")
    private List<String> heritageDomain;
    @Field(value="providesSupportForMediaType")
    private List<String> providesSupportForMediaType;
    @Field(value="providesSupportForDataActivity")
    private List<String> providesSupportForDataActivity;
    @Field(value="providesCapacityBuildingActivity")
    private List<String> providesCapacityBuildingActivity;
    @Field(value="providesAudienceEngagementActivity")
    private List<String> providesAudienceEngagementActivity;

    public SolrAggregator() {
    }

    public SolrAggregator(Aggregator aggregator) {
        super((Organization)aggregator);
        this.mbox = aggregator.getMbox();
        this.geographicScope = aggregator.getGeographicScope();
        if (aggregator.getHeritageDomain() != null) {
            this.heritageDomain = new ArrayList<String>(aggregator.getHeritageDomain());
        }
        if (aggregator.getProvidesSupportForMediaType() != null) {
            this.providesSupportForMediaType = new ArrayList<String>(aggregator.getProvidesSupportForMediaType());
        }
        if (aggregator.getProvidesSupportForDataActivity() != null) {
            this.providesSupportForDataActivity = new ArrayList<String>(aggregator.getProvidesSupportForDataActivity());
        }
        if (aggregator.getProvidesCapacityBuildingActivity() != null) {
            this.providesCapacityBuildingActivity = new ArrayList<String>(aggregator.getProvidesCapacityBuildingActivity());
        }
        if (aggregator.getProvidesAudienceEngagementActivity() != null) {
            this.providesAudienceEngagementActivity = new ArrayList<String>(aggregator.getProvidesAudienceEngagementActivity());
        }
    }

    public String getMbox() {
        return this.mbox;
    }

    public String getGeographicScope() {
        return this.geographicScope;
    }

    public List<String> getHeritageDomain() {
        return this.heritageDomain;
    }

    public List<String> getProvidesSupportForMediaType() {
        return this.providesSupportForMediaType;
    }

    public List<String> getProvidesSupportForDataActivity() {
        return this.providesSupportForDataActivity;
    }

    public List<String> getProvidesCapacityBuildingActivity() {
        return this.providesCapacityBuildingActivity;
    }

    public List<String> getProvidesAudienceEngagementActivity() {
        return this.providesAudienceEngagementActivity;
    }
}

