/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import eu.europeana.entitymanagement.utils.SolrGeneralUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.solr.client.solrj.beans.Field;
import org.springframework.util.CollectionUtils;

public class SolrAgent
extends SolrEntity<Agent> {
    @Field(value="owl_sameAs")
    private List<String> sameAs;
    @Field(value="dc_date")
    private List<String> date;
    @Field(value="edm_begin")
    private List<String> begin;
    @Field(value="edm_end")
    private List<String> end;
    @Field(value="rdagr2_dateOfBirth.*")
    private List<String> dateOfBirth;
    @Field(value="rdagr2_dateOfDeath.*")
    private List<String> dateOfDeath;
    @Field(value="edm_wasPresentAt")
    private List<String> wasPresentAt;
    @Field(value="edm_hasMet")
    private List<String> hasMet;
    @Field(value="foaf_name")
    private Map<String, String> name;
    @Field(value="rdagr2_biographicalInformation.*")
    private Map<String, List<String>> biographicalInformation;
    @Field(value="rdagr2_professionOrOccupation.*")
    private List<String> professionOrOccupation;
    @Field(value="rdagr2_placeOfBirth.*")
    private List<String> placeOfBirth;
    @Field(value="rdagr2_placeOfDeath.*")
    private List<String> placeOfDeath;
    @Field(value="rdagr2_dateOfEstablishment")
    private String dateOfEstablishment;
    @Field(value="rdagr2_dateOfTermination")
    private String dateOfTermination;
    @Field(value="rdagr2_gender")
    private String gender;

    public SolrAgent() {
    }

    public SolrAgent(Agent agent) {
        super(agent);
        if (agent.getDate() != null) {
            this.date = new ArrayList<String>(agent.getDate());
        }
        if (agent.getBegin() != null) {
            this.begin = new ArrayList<String>(agent.getBegin());
        }
        if (agent.getEnd() != null) {
            this.end = new ArrayList<String>(agent.getEnd());
        }
        if (agent.getDateOfBirth() != null) {
            this.dateOfBirth = new ArrayList<String>(agent.getDateOfBirth());
        }
        if (agent.getDateOfDeath() != null) {
            this.dateOfDeath = new ArrayList<String>(agent.getDateOfDeath());
        }
        if (agent.getWasPresentAt() != null) {
            this.wasPresentAt = new ArrayList<String>(agent.getWasPresentAt());
        }
        if (agent.getHasMet() != null) {
            this.hasMet = agent.getHasMet();
        }
        this.setName(agent.getName());
        this.setBiographicalInformation(agent.getBiographicalInformation());
        if (agent.getProfessionOrOccupation() != null) {
            this.professionOrOccupation = new ArrayList<String>(agent.getProfessionOrOccupation());
        }
        if (agent.getPlaceOfBirth() != null) {
            this.placeOfBirth = new ArrayList<String>(agent.getPlaceOfBirth());
        }
        if (agent.getPlaceOfDeath() != null) {
            this.placeOfDeath = new ArrayList<String>(agent.getPlaceOfDeath());
        }
        this.dateOfEstablishment = (String)CollectionUtils.lastElement((List)agent.getDateOfEstablishment());
        this.dateOfTermination = (String)CollectionUtils.lastElement((List)agent.getDateOfTermination());
        this.gender = (String)CollectionUtils.lastElement((List)agent.getGender());
        if (agent.getSameReferenceLinks() != null) {
            this.sameAs = new ArrayList<String>(agent.getSameReferenceLinks());
        }
    }

    private void setBiographicalInformation(Map<String, List<String>> biographicalInformation) {
        if (MapUtils.isNotEmpty(biographicalInformation)) {
            this.biographicalInformation = new HashMap<String, List<String>>(SolrGeneralUtils.normalizeStringListMapByAddingPrefix((String)"rdagr2_biographicalInformation.", biographicalInformation));
        }
    }

    private void setName(Map<String, String> name) {
        if (MapUtils.isNotEmpty(name)) {
            this.name = new HashMap<String, String>(SolrGeneralUtils.normalizeStringMapByAddingPrefix((String)"foaf_name.", name));
        }
    }

    public List<String> getDate() {
        return this.date;
    }

    public List<String> getBegin() {
        return this.begin;
    }

    public List<String> getEnd() {
        return this.end;
    }

    public List<String> getDateOfBirth() {
        return this.dateOfBirth;
    }

    public List<String> getDateOfDeath() {
        return this.dateOfDeath;
    }

    public List<String> getWasPresentAt() {
        return this.wasPresentAt;
    }

    public List<String> getHasMet() {
        return this.hasMet;
    }

    public Map<String, String> getName() {
        return this.name;
    }

    public Map<String, List<String>> getBiographicalInformation() {
        return this.biographicalInformation;
    }

    public List<String> getProfessionOrOccupation() {
        return this.professionOrOccupation;
    }

    public List<String> getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public List<String> getPlaceOfDeath() {
        return this.placeOfDeath;
    }

    public String getDateOfEstablishment() {
        return this.dateOfEstablishment;
    }

    public String getDateOfTermination() {
        return this.dateOfTermination;
    }

    public String getGender() {
        return this.gender;
    }

    @Override
    protected void setSameReferenceLinks(ArrayList<String> uris) {
        this.sameAs = uris;
    }
}

