/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr;

import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.solr.SolrEntityUtils;
import eu.europeana.entitymanagement.solr.exception.InvalidSearchQueryException;
import eu.europeana.entitymanagement.solr.exception.SolrServiceException;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SolrSearchCursorIterator {
    private static final String UNDEFINED_FIELD = "undefined field";
    private static final String CANNOT_PARSE_TEXT_FRAGMENT = "org.apache.solr.search.SyntaxError: Cannot parse ";
    private final DocumentObjectBinder objectBinder = new DocumentObjectBinder();
    private final Logger log = LogManager.getLogger(SolrSearchCursorIterator.class);
    private final SolrClient client;
    private final SolrQuery solrQuery;
    private String cursorMark;
    private String previousCursorMark;

    public SolrSearchCursorIterator(SolrClient client, SolrQuery solrQuery) {
        this.validateQueryFields(solrQuery);
        this.ensureSortClause(solrQuery);
        this.solrQuery = solrQuery;
        this.client = client;
        this.cursorMark = "*";
    }

    public boolean hasNext() {
        return !this.cursorMark.equals(this.previousCursorMark);
    }

    public <T extends Entity> List<SolrEntity<T>> next() throws SolrServiceException {
        SolrDocumentList documents;
        QueryResponse response;
        this.solrQuery.set("cursorMark", new String[]{this.cursorMark});
        try {
            response = this.client.query((SolrParams)this.solrQuery);
        }
        catch (BaseHttpSolrClient.RemoteSolrException e) {
            throw this.handleRemoteSolrException(this.solrQuery, e);
        }
        catch (IOException | SolrServerException ex) {
            throw new SolrServiceException(String.format("Error while searching Solr q=%s", this.solrQuery.getQuery()), ex);
        }
        this.previousCursorMark = this.cursorMark;
        this.cursorMark = response.getNextCursorMark();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Performed Solr search query in {}ms: numFound={}, cursorMark={}, q={}", (Object)response.getElapsedTime(), (Object)response.getResults().getNumFound(), (Object)this.cursorMark, (Object)this.solrQuery.getQuery());
        }
        if (CollectionUtils.isEmpty((Collection)(documents = response.getResults()))) {
            return Collections.emptyList();
        }
        return documents.stream().map(this::convertFromSolrDoc).collect(Collectors.toList());
    }

    private <T extends Entity> SolrEntity<T> convertFromSolrDoc(SolrDocument solrDocument) {
        Object fieldValue = solrDocument.getFieldValue("type");
        Assert.notNull((Object)fieldValue, (String)"Solr document type cannot be empty");
        return (SolrEntity)this.objectBinder.getBean(SolrEntityUtils.getSolrEntityClass(fieldValue.toString()), solrDocument);
    }

    private void validateQueryFields(SolrQuery solrQuery) {
        String fieldString = solrQuery.getFields();
        if (!StringUtils.hasLength((String)fieldString)) {
            return;
        }
        List<String> fields = Arrays.asList(fieldString.split(","));
        if (!Set.of("type", "id").containsAll(fields)) {
            throw new IllegalArgumentException("SolrQuery fields must either be empty or contain id and type");
        }
    }

    private void ensureSortClause(SolrQuery solrQuery) {
        if (CollectionUtils.isEmpty((Collection)solrQuery.getSorts())) {
            throw new IllegalArgumentException("SolrQuery must specify a sort with a unique field");
        }
    }

    private SolrServiceException handleRemoteSolrException(SolrQuery searchQuery, BaseHttpSolrClient.RemoteSolrException e) {
        String remoteMessage = e.getMessage();
        if (remoteMessage.contains(UNDEFINED_FIELD)) {
            int startPos = remoteMessage.indexOf(UNDEFINED_FIELD) + UNDEFINED_FIELD.length();
            String fieldName = remoteMessage.substring(startPos);
            return new InvalidSearchQueryException("Unknown field '" + fieldName + "' in search query");
        }
        if (remoteMessage.contains(CANNOT_PARSE_TEXT_FRAGMENT)) {
            return new InvalidSearchQueryException("Invalid syntax in search query");
        }
        int separatorPos = remoteMessage.lastIndexOf(58);
        if (separatorPos > 0) {
            remoteMessage = remoteMessage.substring(separatorPos + 1);
        }
        return new SolrServiceException("An error occurred when searching entities: " + searchQuery.toString() + ", remote message: " + remoteMessage, e);
    }
}

