/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr;

import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Aggregator;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.solr.model.SolrAgent;
import eu.europeana.entitymanagement.solr.model.SolrAggregator;
import eu.europeana.entitymanagement.solr.model.SolrConcept;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import eu.europeana.entitymanagement.solr.model.SolrOrganization;
import eu.europeana.entitymanagement.solr.model.SolrPlace;
import eu.europeana.entitymanagement.solr.model.SolrTimeSpan;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SolrEntityUtils {
    public static final String SOLR_AGENT_SUGGESTER_FILTER = "solrAgentFilter";
    public static final String SOLR_ORGANIZATION_SUGGESTER_FILTER = "solrOrganizationFilter";
    public static final String SOLR_TIMESPAN_SUGGESTER_FILTER = "solrTimeSpanFilter";
    public static final String SOLR_PLACE_SUGGESTER_FILTER = "solrPlaceFilter";
    public static final String SOLR_CONCEPT_SUGGESTER_FILTER = "solrConceptFilter";
    public static final int MAX_FILTERS = 3;

    private SolrEntityUtils() {
    }

    public static Class<? extends SolrEntity> getSolrEntityClass(String solrType) {
        Class solrEntityClass = null;
        switch (EntityTypes.valueOf((String)solrType)) {
            case Agent: {
                solrEntityClass = SolrAgent.class;
                break;
            }
            case Concept: {
                solrEntityClass = SolrConcept.class;
                break;
            }
            case Organization: {
                solrEntityClass = SolrOrganization.class;
                break;
            }
            case Aggregator: {
                solrEntityClass = SolrAggregator.class;
                break;
            }
            case Place: {
                solrEntityClass = SolrPlace.class;
                break;
            }
            case TimeSpan: {
                solrEntityClass = SolrTimeSpan.class;
                break;
            }
            case ConceptScheme: {
                break;
            }
        }
        if (solrEntityClass == null) {
            throw new IllegalArgumentException(String.format("Unrecognized entity type while determining Solr entity class: %s ", solrType));
        }
        return solrEntityClass;
    }

    public static SolrEntity<? extends Entity> createSolrEntity(EntityRecord record) {
        Entity entity = record.getEntity();
        SolrEntity solrEntity = null;
        switch (EntityTypes.valueOf((String)entity.getType())) {
            case Agent: {
                solrEntity = new SolrAgent((Agent)entity);
                break;
            }
            case Concept: {
                solrEntity = new SolrConcept((Concept)entity);
                break;
            }
            case Organization: {
                solrEntity = new SolrOrganization((Organization)entity);
                break;
            }
            case Aggregator: {
                solrEntity = new SolrAggregator((Aggregator)entity);
                break;
            }
            case Place: {
                solrEntity = new SolrPlace((Place)entity);
                break;
            }
            case TimeSpan: {
                solrEntity = new SolrTimeSpan((TimeSpan)entity);
                break;
            }
            case ConceptScheme: {
                break;
            }
        }
        if (solrEntity == null) {
            throw new IllegalArgumentException(String.format("Unrecognized entity type while creating SolrEntity: %s ", entity.getClass().getName()));
        }
        SolrEntityUtils.setMetricsAndFilters(solrEntity, record);
        SolrEntityUtils.setLabelEnrich(solrEntity, record);
        return solrEntity;
    }

    private static void setLabelEnrich(SolrEntity<? extends Entity> solrEntity, EntityRecord record) {
        if (SolrEntityUtils.isEnrichmentDisabled(record)) {
            return;
        }
        solrEntity.setLabelEnrichGeneral(SolrEntityUtils.collectLabelEnrichGeneral(record));
        solrEntity.setLabelEnrich(SolrEntityUtils.collectLabelEnrich(record));
    }

    private static List<String> collectLabelEnrichGeneral(EntityRecord record) {
        Map acronyms;
        ArrayList<String> values = new ArrayList<String>();
        Entity entity = record.getEntity();
        if (entity == null) {
            return values;
        }
        values.addAll(entity.getPrefLabel().values());
        Map altLabels = entity.getAltLabel();
        if (altLabels != null) {
            for (Map.Entry entry : altLabels.entrySet()) {
                values.addAll((Collection)entry.getValue());
            }
        }
        if (entity.getHiddenLabel() != null) {
            values.addAll(entity.getHiddenLabel());
        }
        if (entity instanceof Organization && (acronyms = ((Organization)entity).getAcronym()) != null) {
            for (Map.Entry entry : acronyms.entrySet()) {
                values.addAll((Collection)entry.getValue());
            }
        }
        return values;
    }

    private static Map<String, List<String>> collectLabelEnrich(EntityRecord record) {
        Map map;
        Entity entity = record.getEntity();
        ConcurrentHashMap<String, List<String>> values = new ConcurrentHashMap<String, List<String>>();
        if (entity == null) {
            return values;
        }
        for (Map.Entry entry : entity.getPrefLabel().entrySet()) {
            SolrEntityUtils.addLabel(values, (String)entry.getKey(), (String)entry.getValue());
        }
        Map altLabels = entity.getAltLabel();
        if (altLabels != null) {
            for (Map.Entry entry : altLabels.entrySet()) {
                SolrEntityUtils.addLabels(values, (String)entry.getKey(), (List)entry.getValue());
            }
        }
        if (entity instanceof Organization && (map = ((Organization)entity).getAcronym()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                SolrEntityUtils.addLabels(values, (String)entry.getKey(), (List)entry.getValue());
            }
        }
        if (entity.getHiddenLabel() != null) {
            for (Map.Entry entry : values.entrySet()) {
                ((List)entry.getValue()).addAll(entity.getHiddenLabel());
            }
        }
        return values;
    }

    private static void addLabel(Map<String, List<String>> labelMap, String language, String label) {
        if (labelMap.containsKey(language)) {
            labelMap.get(language).add(label);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(label);
            labelMap.put(language, values);
        }
    }

    private static void addLabels(Map<String, List<String>> labelMap, String language, List<String> labels) {
        if (labelMap.containsKey(language)) {
            labelMap.get(language).addAll(labels);
        } else {
            ArrayList<String> values = new ArrayList<String>(labels);
            labelMap.put(language, values);
        }
    }

    private static boolean isEnrichmentDisabled(EntityRecord record) {
        boolean notConsolidated;
        boolean bl = notConsolidated = record.getEntity() == null || record.getEntity().getIsAggregatedBy() == null;
        if (notConsolidated) {
            return true;
        }
        return Boolean.FALSE.equals(record.getEntity().getIsAggregatedBy().getEnrich());
    }

    private static void setMetricsAndFilters(SolrEntity<? extends Entity> solrEntity, EntityRecord record) {
        Aggregation aggregation = record.getEntity().getIsAggregatedBy();
        if (aggregation != null) {
            solrEntity.setDocCount(aggregation.getRecordCount());
            if (aggregation.getPageRank() != null) {
                solrEntity.setPageRank(Float.valueOf(aggregation.getPageRank().floatValue()));
            }
            if (aggregation.getScore() != null) {
                solrEntity.setDerivedScore(Float.valueOf(aggregation.getScore().floatValue()));
            }
        }
        EntityTypes entityType = EntityTypes.valueOf((String)solrEntity.getType());
        ArrayList<String> filters = new ArrayList<String>(3);
        filters.add(entityType.getEntityType());
        if (entityType.getParentType() != null) {
            filters.add(entityType.getParentType());
        }
        if (solrEntity.getDocCount() != null && solrEntity.getDocCount() > 0) {
            filters.add("europeana");
        }
        solrEntity.setSuggestFilters(filters);
    }
}

