/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import eu.europeana.entitymanagement.definitions.model.ConceptScheme;
import eu.europeana.entitymanagement.solr.SolrUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.solr.client.solrj.beans.Field;

public class SolrConceptScheme {
    @Field(value="id")
    private String entityId;
    @Field(value="type")
    private String type;
    @Field(value="skos_prefLabel.*")
    private Map<String, String> prefLabel;
    @Field(value="skos_definition.*")
    private Map<String, String> definition;
    @Field(value="skos_subject")
    private String subject;
    @Field(value="created")
    private Date created;
    @Field(value="modified")
    private Date modified;

    public SolrConceptScheme() {
    }

    public SolrConceptScheme(ConceptScheme conceptScheme) {
        this.type = conceptScheme.getType();
        this.entityId = conceptScheme.getConceptSchemeId();
        this.subject = conceptScheme.getSubject();
        this.created = conceptScheme.getCreated();
        this.modified = conceptScheme.getModified();
        this.setDefinitionStringMap(conceptScheme.getDefinition());
        this.setPrefLabelStringMap(conceptScheme.getPrefLabel());
    }

    private void setDefinitionStringMap(Map<String, String> definition) {
        if (MapUtils.isNotEmpty(definition)) {
            this.definition = new HashMap<String, String>(SolrUtils.normalizeStringMapByAddingPrefix("skos_definition.", definition));
        }
    }

    private void setPrefLabelStringMap(Map<String, String> prefLabel) {
        if (MapUtils.isNotEmpty(prefLabel)) {
            this.prefLabel = new HashMap<String, String>(SolrUtils.normalizeStringMapByAddingPrefix("skos_prefLabel.", prefLabel));
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getPrefLabel() {
        return this.prefLabel;
    }

    public Map<String, String> getDefinition() {
        return this.definition;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getModified() {
        return this.modified;
    }
}

