/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.beans.Field;

public class SolrPlace
extends SolrEntity<Place> {
    @Field(value="owl_sameAs")
    private List<String> sameAs;
    @Field(value="edm_isNextInSequence")
    private List<String> isNextInSequence;
    @Field(value="wgs84_pos_lat")
    private Float latitude;
    @Field(value="wgs84_pos_long")
    private Float longitude;
    @Field(value="wgs84_pos_alt")
    private Float altitude;

    public SolrPlace() {
    }

    public SolrPlace(Place place) {
        super(place);
        if (place.getIsNextInSequence() != null) {
            this.isNextInSequence = new ArrayList<String>(place.getIsNextInSequence());
        }
        this.latitude = place.getLatitude();
        this.longitude = place.getLongitude();
        this.altitude = place.getAltitude();
        if (place.getSameReferenceLinks() != null) {
            this.sameAs = new ArrayList<String>(place.getSameReferenceLinks());
        }
    }

    public List<String> getIsNextInSequence() {
        return this.isNextInSequence;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public Float getAltitude() {
        return this.altitude;
    }

    @Override
    protected void setSameReferenceLinks(ArrayList<String> uris) {
        this.sameAs = uris;
    }
}

