/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr;

import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.solr.model.SolrAgent;
import eu.europeana.entitymanagement.solr.model.SolrConcept;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import eu.europeana.entitymanagement.solr.model.SolrOrganization;
import eu.europeana.entitymanagement.solr.model.SolrPlace;
import eu.europeana.entitymanagement.solr.model.SolrTimeSpan;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;

public class SolrUtils {
    public static final String SOLR_AGENT_SUGGESTER_FILTER = "solrAgentFilter";
    public static final String SOLR_ORGANIZATION_SUGGESTER_FILTER = "solrOrganizationFilter";
    public static final String SOLR_TIMESPAN_SUGGESTER_FILTER = "solrTimeSpanFilter";
    public static final String SOLR_PLACE_SUGGESTER_FILTER = "solrPlaceFilter";
    public static final String SOLR_CONCEPT_SUGGESTER_FILTER = "solrConceptFilter";

    public static Map<String, List<String>> normalizeStringListMapByAddingPrefix(String fieldNamePrefix, Map<String, List<String>> languageMap) {
        if (MapUtils.isEmpty(languageMap)) {
            return new HashMap<String, List<String>>();
        }
        Map<String, List<String>> res = !languageMap.keySet().iterator().next().contains(fieldNamePrefix) ? languageMap.entrySet().stream().collect(Collectors.toMap(entry -> fieldNamePrefix + (String)entry.getKey(), Map.Entry::getValue)) : languageMap;
        return res;
    }

    public static Map<String, String> normalizeStringMapByAddingPrefix(String fieldNamePrefix, Map<String, String> languageMap) {
        if (MapUtils.isEmpty(languageMap)) {
            return new HashMap<String, String>();
        }
        Map<String, String> res = !languageMap.keySet().iterator().next().contains(fieldNamePrefix) ? languageMap.entrySet().stream().collect(Collectors.toMap(entry -> fieldNamePrefix + (String)entry.getKey(), Map.Entry::getValue)) : languageMap;
        return res;
    }

    public static <T extends Entity, U extends SolrEntity<T>> Class<U> getSolrEntityClass(String solrType) {
        if (solrType.equals(EntityTypes.Agent.getEntityType())) {
            return SolrAgent.class;
        }
        if (solrType.equals(EntityTypes.Concept.getEntityType())) {
            return SolrConcept.class;
        }
        if (solrType.equals(EntityTypes.Organization.getEntityType())) {
            return SolrOrganization.class;
        }
        if (solrType.equals(EntityTypes.Place.getEntityType())) {
            return SolrPlace.class;
        }
        if (solrType.equalsIgnoreCase(EntityTypes.TimeSpan.getEntityType())) {
            return SolrTimeSpan.class;
        }
        throw new IllegalArgumentException(String.format("Unrecognized entity type while determining Solr entity class: %s ", solrType));
    }

    public static SolrEntity<? extends Entity> createSolrEntity(EntityRecord record) {
        Entity entity = record.getEntity();
        SolrEntity solrEntity = null;
        if (entity instanceof Agent) {
            solrEntity = new SolrAgent((Agent)entity);
        } else if (entity instanceof Concept) {
            solrEntity = new SolrConcept((Concept)entity);
        } else if (entity instanceof Organization) {
            solrEntity = new SolrOrganization((Organization)entity);
        } else if (entity instanceof Place) {
            solrEntity = new SolrPlace((Place)entity);
        } else if (entity instanceof TimeSpan) {
            solrEntity = new SolrTimeSpan((TimeSpan)entity);
        }
        if (solrEntity == null) {
            throw new IllegalArgumentException(String.format("Unrecognized entity type while creating SolrEntity: %s ", entity.getClass().getName()));
        }
        SolrUtils.setMetricsAndFilters(solrEntity, record);
        SolrUtils.setLabelEnrich(solrEntity, record);
        return solrEntity;
    }

    private static void setLabelEnrich(SolrEntity<? extends Entity> solrEntity, EntityRecord record) {
        if (SolrUtils.isEnrichmentDisabled(record)) {
            return;
        }
        solrEntity.setLabelEnrichGeneral(SolrUtils.collectLabelEnrichGeneral(record));
        solrEntity.setLabelEnrich(SolrUtils.collectLabelEnrich(record));
    }

    private static List<String> collectLabelEnrichGeneral(EntityRecord record) {
        Map acronyms;
        ArrayList<String> values = new ArrayList<String>();
        Entity entity = record.getEntity();
        if (entity == null) {
            return values;
        }
        values.addAll(entity.getPrefLabel().values());
        Map altLabels = entity.getAltLabel();
        if (altLabels != null) {
            for (Map.Entry entry : altLabels.entrySet()) {
                values.addAll((Collection)entry.getValue());
            }
        }
        if (entity.getHiddenLabel() != null) {
            values.addAll(entity.getHiddenLabel());
        }
        if (entity instanceof Organization && (acronyms = ((Organization)entity).getAcronym()) != null) {
            for (Map.Entry entry : acronyms.entrySet()) {
                values.addAll((Collection)entry.getValue());
            }
        }
        return values;
    }

    private static Map<String, List<String>> collectLabelEnrich(EntityRecord record) {
        Map map;
        Entity entity = record.getEntity();
        HashMap<String, List<String>> values = new HashMap<String, List<String>>();
        if (entity == null) {
            return values;
        }
        for (Map.Entry entry : entity.getPrefLabel().entrySet()) {
            SolrUtils.addLabel(values, (String)entry.getKey(), (String)entry.getValue());
        }
        Map altLabels = entity.getAltLabel();
        if (altLabels != null) {
            for (Map.Entry entry : altLabels.entrySet()) {
                SolrUtils.addLabels(values, (String)entry.getKey(), (List)entry.getValue());
            }
        }
        if (entity instanceof Organization && (map = ((Organization)entity).getAcronym()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                SolrUtils.addLabels(values, (String)entry.getKey(), (List)entry.getValue());
            }
        }
        if (entity.getHiddenLabel() != null) {
            for (Map.Entry entry : values.entrySet()) {
                ((List)entry.getValue()).addAll(entity.getHiddenLabel());
            }
        }
        return values;
    }

    private static void addLabel(Map<String, List<String>> labelMap, String language, String label) {
        if (labelMap.containsKey(language)) {
            labelMap.get(language).add(label);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(label);
            labelMap.put(language, values);
        }
    }

    private static void addLabels(Map<String, List<String>> labelMap, String language, List<String> labels) {
        if (labelMap.containsKey(language)) {
            labelMap.get(language).addAll(labels);
        } else {
            ArrayList<String> values = new ArrayList<String>(labels);
            labelMap.put(language, values);
        }
    }

    private static boolean isEnrichmentDisabled(EntityRecord record) {
        if (record.getEntity() == null || record.getEntity().getIsAggregatedBy() == null) {
            return true;
        }
        return Boolean.FALSE.equals(record.getEntity().getIsAggregatedBy().getEnrich());
    }

    private static void setMetricsAndFilters(SolrEntity<? extends Entity> solrEntity, EntityRecord record) {
        Aggregation aggregation = record.getEntity().getIsAggregatedBy();
        if (aggregation != null) {
            solrEntity.setDocCount(aggregation.getRecordCount());
            if (aggregation.getPageRank() != null) {
                solrEntity.setPageRank(Float.valueOf(aggregation.getPageRank().floatValue()));
            }
            if (aggregation.getScore() != null) {
                solrEntity.setDerivedScore(Float.valueOf(aggregation.getScore().floatValue()));
            }
        }
        if (solrEntity.getDocCount() != null && solrEntity.getDocCount() > 0) {
            solrEntity.setSuggestFilters(Arrays.asList(solrEntity.getType(), "europeana"));
        } else {
            solrEntity.setSuggestFilters(List.of(solrEntity.getType()));
        }
    }
}

