/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.solr.SolrUtils;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.solr.client.solrj.beans.Field;

public class SolrConcept
extends SolrEntity<Concept> {
    @Field(value="skos_broader")
    private List<String> broader;
    @Field(value="skos_narrower")
    private List<String> narrower;
    @Field(value="skos_related")
    private List<String> related;
    @Field(value="skos_broadMatch")
    private List<String> broadMatch;
    @Field(value="skos_narrowMatch")
    private List<String> narrowMatch;
    @Field(value="skos_exactMatch")
    private List<String> exactMatch;
    @Field(value="coref")
    private List<String> coref;
    @Field(value="skos_relatedMatch")
    private List<String> relatedMatch;
    @Field(value="skos_closeMatch")
    private List<String> closeMatch;
    @Field(value="skos_notation.*")
    Map<String, List<String>> notation;

    public SolrConcept() {
    }

    public SolrConcept(Concept concept) {
        super(concept);
        if (concept.getBroader() != null) {
            this.broader = new ArrayList<String>(concept.getBroader());
        }
        if (concept.getNarrower() != null) {
            this.narrower = new ArrayList<String>(concept.getNarrower());
        }
        if (concept.getRelated() != null) {
            this.related = new ArrayList<String>(concept.getRelated());
        }
        if (concept.getBroadMatch() != null) {
            this.broadMatch = new ArrayList<String>(concept.getBroadMatch());
        }
        if (concept.getNarrowMatch() != null) {
            this.narrowMatch = new ArrayList<String>(concept.getNarrowMatch());
        }
        if (concept.getCoref() != null) {
            this.coref = new ArrayList<String>(concept.getCoref());
        }
        if (concept.getRelatedMatch() != null) {
            this.relatedMatch = new ArrayList<String>(concept.getRelatedMatch());
        }
        if (concept.getCloseMatch() != null) {
            this.closeMatch = new ArrayList<String>(concept.getCloseMatch());
        }
        this.setNotation(concept.getNotation());
        if (concept.getSameReferenceLinks() != null) {
            this.exactMatch = new ArrayList<String>(concept.getSameReferenceLinks());
        }
    }

    private void setNotation(Map<String, List<String>> notation) {
        if (MapUtils.isNotEmpty(notation)) {
            this.notation = new HashMap<String, List<String>>(SolrUtils.normalizeStringListMapByAddingPrefix("skos_notation.", notation));
        }
    }

    public List<String> getBroader() {
        return this.broader;
    }

    public List<String> getNarrower() {
        return this.narrower;
    }

    public List<String> getRelated() {
        return this.related;
    }

    public List<String> getBroadMatch() {
        return this.broadMatch;
    }

    public List<String> getNarrowMatch() {
        return this.narrowMatch;
    }

    public List<String> getExactMatch() {
        return this.exactMatch;
    }

    public List<String> getCoref() {
        return this.coref;
    }

    public List<String> getRelatedMatch() {
        return this.relatedMatch;
    }

    public List<String> getCloseMatch() {
        return this.closeMatch;
    }

    public Map<String, List<String>> getNotation() {
        return this.notation;
    }

    @Override
    protected void setSameReferenceLinks(ArrayList<String> uris) {
        this.exactMatch = uris;
    }
}

