/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.solr.SolrUtils;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import eu.europeana.entitymanagement.utils.EntityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.solr.client.solrj.beans.Field;

public class SolrOrganization
extends SolrEntity<Organization> {
    @Field(value="owl_sameAs")
    private List<String> sameAs;
    @Field(value="dc_description.*")
    private Map<String, String> description;
    @Field(value="edm_acronym.*")
    private Map<String, List<String>> acronym;
    @Field(value="foaf_logo")
    private String logo;
    @Field(value="foaf_homepage")
    private String homepage;
    @Field(value="foaf_phone")
    private List<String> phone;
    @Field(value="foaf_mbox")
    private List<String> mbox;
    @Field(value="europeanaRole.*")
    private Map<String, List<String>> europeanaRole;
    @Field(value="organizationDomain.*")
    private Map<String, List<String>> organizationDomain;
    @Field(value="geographicLevel.*")
    private Map<String, String> geographicLevel;
    @Field(value="country")
    private String country;
    @Field(value="vcard_hasAddress.1")
    private String hasAddress;
    @Field(value="vcard_streetAddress.1")
    private String streetAddress;
    @Field(value="vcard_locality.1")
    private String locality;
    @Field(value="vcard_region.1")
    private String region;
    @Field(value="vcard_postalCode.1")
    private String postalCode;
    @Field(value="vcard_countryName.1")
    private String countryName;
    @Field(value="vcard_postOfficeBox.1")
    private String postBox;
    @Field(value="hasGeo")
    private String hasGeo;

    public SolrOrganization() {
    }

    public SolrOrganization(Organization organization) {
        super(organization);
        Address organizationAddress;
        this.setDescription(organization.getDescription());
        this.setAcronym(organization.getAcronym());
        if (organization.getLogo() != null) {
            this.logo = organization.getLogo().getId();
        }
        this.homepage = organization.getHomepage();
        this.phone = organization.getPhone();
        if (organization.getMbox() != null) {
            this.mbox = new ArrayList<String>(organization.getMbox());
        }
        this.setEuropeanaRole(organization.getEuropeanaRole());
        this.setOrganizationDomain(organization.getOrganizationDomain());
        this.setGeographicLevel(organization.getGeographicLevel());
        this.country = organization.getCountry();
        if (organization.getSameReferenceLinks() != null) {
            this.sameAs = new ArrayList<String>(organization.getSameReferenceLinks());
        }
        if ((organizationAddress = organization.getAddress()) != null) {
            this.hasAddress = organizationAddress.getAbout();
            this.streetAddress = organizationAddress.getVcardStreetAddress();
            this.locality = organizationAddress.getVcardLocality();
            this.postalCode = organizationAddress.getVcardPostalCode();
            this.countryName = organizationAddress.getVcardCountryName();
            this.postBox = organizationAddress.getVcardPostOfficeBox();
            this.hasGeo = EntityUtils.toLatLongValue((String)organizationAddress.getVcardHasGeo());
        }
    }

    private void setDescription(Map<String, String> dcDescription) {
        if (MapUtils.isNotEmpty(dcDescription)) {
            this.description = new HashMap<String, String>(SolrUtils.normalizeStringMapByAddingPrefix("dc_description.", dcDescription));
        }
    }

    private void setAcronym(Map<String, List<String>> acronym) {
        if (MapUtils.isNotEmpty(acronym)) {
            this.acronym = new HashMap<String, List<String>>(SolrUtils.normalizeStringListMapByAddingPrefix("edm_acronym.", acronym));
        }
    }

    private void setGeographicLevel(Map<String, String> geographicLevel) {
        if (MapUtils.isNotEmpty(geographicLevel)) {
            this.geographicLevel = new HashMap<String, String>(SolrUtils.normalizeStringMapByAddingPrefix("geographicLevel.", geographicLevel));
        }
    }

    private void setOrganizationDomain(Map<String, List<String>> organizationDomain) {
        if (MapUtils.isNotEmpty(organizationDomain)) {
            this.organizationDomain = new HashMap<String, List<String>>(SolrUtils.normalizeStringListMapByAddingPrefix("organizationDomain.", organizationDomain));
        }
    }

    private void setEuropeanaRole(Map<String, List<String>> europeanaRole) {
        if (MapUtils.isNotEmpty(europeanaRole)) {
            this.europeanaRole = new HashMap<String, List<String>>(SolrUtils.normalizeStringListMapByAddingPrefix("europeanaRole.", europeanaRole));
        }
    }

    public Map<String, String> getDescription() {
        return this.description;
    }

    public Map<String, List<String>> getAcronym() {
        return this.acronym;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public List<String> getPhone() {
        return this.phone;
    }

    public List<String> getMbox() {
        return this.mbox;
    }

    public Map<String, List<String>> getEuropeanaRole() {
        return this.europeanaRole;
    }

    public Map<String, List<String>> getOrganizationDomain() {
        return this.organizationDomain;
    }

    public Map<String, String> getGeographicLevel() {
        return this.geographicLevel;
    }

    public String getCountry() {
        return this.country;
    }

    public String getHasAddress() {
        return this.hasAddress;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getPostBox() {
        return this.postBox;
    }

    public String getHasGeo() {
        return this.hasGeo;
    }

    @Override
    protected void setSameReferenceLinks(ArrayList<String> uris) {
        this.sameAs = uris;
    }
}

