/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import eu.europeana.entitymanagement.common.config.EntityManagementConfiguration;
import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.solr.SolrEntitySuggesterMixins;
import eu.europeana.entitymanagement.solr.SolrSearchCursorIterator;
import eu.europeana.entitymanagement.solr.SolrUtils;
import eu.europeana.entitymanagement.solr.exception.SolrServiceException;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import eu.europeana.entitymanagement.solr.model.SolrOrganization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.beans.BindingException;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="emSolrService")
public class SolrService
implements InitializingBean {
    private final ObjectMapper payloadMapper;
    private final Logger log = LogManager.getLogger(this.getClass());
    private final SolrClient solrClient;
    private final FilterProvider solrEntityFilter;
    private final boolean isExplicitCommitsEnabled;
    private final int solrQueryMaxRows;

    @Autowired
    public SolrService(@Qualifier(value="indexingSolrClient") SolrClient solrClient, EntityManagementConfiguration configuration, @Qualifier(value="emJsonMapper") ObjectMapper objectMapper, @Qualifier(value="solrEntityFilter") FilterProvider solrEntityFilter) {
        this.solrClient = solrClient;
        this.isExplicitCommitsEnabled = configuration.explicitCommitsEnabled();
        this.solrQueryMaxRows = configuration.getSolrQueryMaxPageSize();
        this.payloadMapper = objectMapper.copy();
        this.solrEntityFilter = solrEntityFilter;
    }

    public void afterPropertiesSet() {
        this.payloadMapper.addMixIn(Agent.class, SolrEntitySuggesterMixins.AgentSuggesterMixin.class);
        this.payloadMapper.addMixIn(Organization.class, SolrEntitySuggesterMixins.OrganizationSuggesterMixin.class);
        this.payloadMapper.addMixIn(TimeSpan.class, SolrEntitySuggesterMixins.TimeSpanSuggesterMixin.class);
        this.payloadMapper.addMixIn(Concept.class, SolrEntitySuggesterMixins.ConceptSuggesterMixin.class);
        this.payloadMapper.addMixIn(Place.class, SolrEntitySuggesterMixins.PlaceSuggesterMixin.class);
        this.payloadMapper.setFilterProvider(this.solrEntityFilter);
    }

    public void storeEntity(SolrEntity<? extends Entity> solrEntity) throws SolrServiceException {
        this.setPayload(solrEntity);
        try {
            UpdateResponse rsp = this.solrClient.addBean(solrEntity);
            if (this.isExplicitCommitsEnabled) {
                this.solrClient.commit();
                this.log.debug("Performed explicit commit for entityId={}", (Object)solrEntity.getEntityId());
            }
            this.log.debug("Indexed entity to Solr in {}ms: entityId={}", (Object)rsp.getElapsedTime(), (Object)solrEntity.getEntityId());
        }
        catch (IOException | RuntimeException | SolrServerException ex) {
            throw new SolrServiceException(String.format("Error during Solr indexing for entityId=%s", solrEntity.getEntityId()), ex);
        }
    }

    public void storeMultipleEntities(List<SolrEntity<? extends Entity>> solrEntityList) throws SolrServiceException {
        if (CollectionUtils.isEmpty(solrEntityList)) {
            return;
        }
        for (SolrEntity<?> solrEntity : solrEntityList) {
            this.setPayload(solrEntity);
        }
        String entityIds = Arrays.toString(this.getEntityIds(solrEntityList));
        try {
            UpdateResponse updateResponse = this.solrClient.addBeans(solrEntityList);
            if (this.isExplicitCommitsEnabled) {
                this.solrClient.commit();
                this.log.debug("Performed explicit commit for entityIds={}", (Object)entityIds);
            }
            this.log.debug("Indexed {} entities to Solr in {}ms: entityIds={}", (Object)solrEntityList.size(), (Object)updateResponse.getElapsedTime(), (Object)entityIds);
        }
        catch (IOException | RuntimeException | SolrServerException throwable) {
            throw new SolrServiceException(String.format("Error during Solr indexing for multiple entities, entityIds=%s", entityIds), throwable);
        }
    }

    public <T extends Entity, U extends SolrEntity<T>> U searchById(Class<U> classType, String entityId) throws SolrServiceException {
        QueryResponse rsp;
        SolrQuery query = new SolrQuery();
        query.set("q", new String[]{"id:\"" + entityId + "\""});
        try {
            rsp = this.solrClient.query((SolrParams)query);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Performed Solr search query in {}ms:  type={}, query={}", (Object)rsp.getElapsedTime(), (Object)classType.getSimpleName(), (Object)query);
            }
        }
        catch (IOException | SolrServerException ex) {
            throw new SolrServiceException(String.format("Error while searching Solr for entityId=%s", entityId), ex);
        }
        DocumentObjectBinder binder = new DocumentObjectBinder();
        SolrDocumentList docList = rsp.getResults();
        if (docList == null || docList.size() == 0) {
            return null;
        }
        SolrDocument doc = (SolrDocument)docList.get(0);
        return (U)((SolrEntity)binder.getBean(classType, doc));
    }

    public List<SolrEntity<Entity>> searchByQuery(SolrQuery query) throws SolrServiceException {
        QueryResponse rsp;
        try {
            rsp = this.solrClient.query((SolrParams)query);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Performed Solr search query in {}ms:  query={}", (Object)rsp.getElapsedTime(), (Object)query);
            }
        }
        catch (IOException | SolrServerException ex) {
            throw new SolrServiceException(String.format("Error while searching Solr for query=%s", query), ex);
        }
        return this.getEntityList(rsp);
    }

    List<SolrEntity<Entity>> getEntityList(QueryResponse rsp) throws SolrServiceException {
        SolrDocumentList docList = rsp.getResults();
        if (docList == null || docList.isEmpty()) {
            return null;
        }
        try {
            ArrayList<SolrEntity<Entity>> res = new ArrayList<SolrEntity<Entity>>(docList.size());
            DocumentObjectBinder binder = new DocumentObjectBinder();
            for (SolrDocument solrDocument : docList) {
                String type = (String)solrDocument.get((Object)"type");
                Class classType = SolrUtils.getSolrEntityClass(type);
                res.add((SolrEntity)binder.getBean(classType, solrDocument));
            }
            return res;
        }
        catch (BindingException e) {
            throw new SolrServiceException("Cannot parse solr response.", e);
        }
    }

    public SolrSearchCursorIterator getSearchIterator(String searchQueryString, List<String> fields) {
        SolrQuery q = new SolrQuery(searchQueryString).setRows(Integer.valueOf(this.solrQueryMaxRows)).setFields((String[])fields.toArray(String[]::new)).setSort(SolrQuery.SortClause.asc((String)"id"));
        return new SolrSearchCursorIterator(this.solrClient, q);
    }

    public SolrSearchCursorIterator getSearchIterator(String searchQueryString) {
        return this.getSearchIterator(searchQueryString, Collections.emptyList());
    }

    public void deleteById(List<String> entityIds, boolean forceCommit) throws SolrServiceException {
        try {
            UpdateResponse updateResponse = this.solrClient.deleteById(entityIds);
            if (forceCommit || this.isExplicitCommitsEnabled) {
                this.solrClient.commit();
            }
            this.log.info("Deleted {} documents from Solr; entityIds={}", (Object)updateResponse.getResponse().size(), entityIds);
        }
        catch (IOException | SolrServerException e) {
            throw new SolrServiceException(String.format("Error deleting entityId=%s", entityIds), e);
        }
    }

    public void deleteAllDocuments() throws Exception {
        UpdateResponse response = this.solrClient.deleteByQuery("*");
        this.solrClient.commit();
        this.log.info("Deleted all documents from Solr in {}ms", (Object)response.getElapsedTime());
    }

    private String createPayload(SolrEntity<? extends Entity> solrEntity) throws JsonProcessingException {
        if (solrEntity instanceof SolrOrganization) {
            ObjectNode agentJacksonNode = (ObjectNode)this.payloadMapper.valueToTree((Object)solrEntity.getEntity());
            JsonNode organizationDomainNode = agentJacksonNode.get("organizationDomain");
            if (organizationDomainNode != null && organizationDomainNode.toString().contains("\"en\"")) {
                agentJacksonNode.replace("organizationDomain", organizationDomainNode.get("\"en\""));
            }
            return this.payloadMapper.writeValueAsString((Object)agentJacksonNode);
        }
        return this.payloadMapper.writeValueAsString((Object)solrEntity.getEntity());
    }

    private void setPayload(SolrEntity<? extends Entity> solrEntity) throws SolrServiceException {
        try {
            solrEntity.setPayload(this.createPayload(solrEntity));
        }
        catch (JsonProcessingException e) {
            throw new SolrServiceException(String.format("Error generating Solr payload for entityId=%s", solrEntity.getEntityId()), e);
        }
    }

    private String[] getEntityIds(List<SolrEntity<?>> solrEntityList) {
        return (String[])solrEntityList.stream().map(SolrEntity::getEntityId).toArray(String[]::new);
    }
}

