/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.beans.Field;

@JsonFilter(value="solrTimeSpanFilter")
public class SolrTimeSpan
extends SolrEntity<TimeSpan> {
    @Field(value="owl_sameAs")
    private List<String> sameAs;
    @Field(value="edm_isNextInSequence")
    private List<String> isNextInSequence;
    @Field(value="edm_begin")
    private String begin;
    @Field(value="edm_end")
    private String end;

    public SolrTimeSpan() {
    }

    public SolrTimeSpan(TimeSpan timespan) {
        super(timespan);
        this.isNextInSequence = timespan.getIsNextInSequence();
        this.begin = timespan.getBeginString();
        this.end = timespan.getEndString();
        if (timespan.getSameReferenceLinks() != null) {
            this.sameAs = new ArrayList<String>(timespan.getSameReferenceLinks());
        }
    }

    public List<String> getIsNextInSequence() {
        return this.isNextInSequence;
    }

    public String getBegin() {
        return this.begin;
    }

    public String getEnd() {
        return this.end;
    }

    @Override
    protected void setSameReferenceLinks(ArrayList<String> uris) {
        this.sameAs = uris;
    }
}

